/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.api;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.streams.operators.CompletionSubscriber;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.Mocks;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompletionSubscriberVerification {
    @Test
    public void completionSubscriberShouldReturnSameCompletionStage() {
        CompletableFuture future = new CompletableFuture();
        Assert.assertSame((Object)CompletionSubscriber.of((Subscriber)Mocks.SUBSCRIBER, future).getCompletion(), future);
    }

    @Test
    public void completionSubscriberShouldDelegateToSubscriber() {
        final ArrayDeque calls = new ArrayDeque();
        CompletionSubscriber subscriber = CompletionSubscriber.of((Subscriber)new Subscriber(){

            public void onSubscribe(Subscription s) {
                calls.add(s);
            }

            public void onNext(Object o) {
                calls.add(o);
            }

            public void onError(Throwable t) {
                calls.add(t);
            }

            public void onComplete() {
                calls.add("onComplete");
            }
        }, new CompletableFuture());
        subscriber.onSubscribe(Mocks.SUBSCRIPTION);
        Assert.assertSame(calls.removeFirst(), (Object)Mocks.SUBSCRIPTION);
        subscriber.onNext((Object)"element");
        Assert.assertEquals(calls.removeFirst(), (Object)"element");
        Exception e = new Exception();
        subscriber.onError((Throwable)e);
        Assert.assertSame(calls.removeFirst(), (Object)e);
        subscriber.onComplete();
        Assert.assertEquals(calls.removeFirst(), (Object)"onComplete");
        Assert.assertTrue((boolean)calls.isEmpty());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void completionSubscriberShouldNotAcceptNullSubscriber() {
        CompletionSubscriber.of(null, new CompletableFuture());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void completionSubscriberShouldNotAcceptNullCompletionStage() {
        CompletionSubscriber.of((Subscriber)Mocks.SUBSCRIBER, null);
    }
}

