/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import jakarta.inject.Inject;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.channel.overflow.BeanUsingBufferOverflowWithoutBufferSizeStrategy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class DefaultOverflowStrategyOverflowWithoutBufferSizeTest
extends TckBase {
    @Inject
    private BeanUsingBufferOverflowWithoutBufferSizeStrategy bean;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        return ((JavaArchive)DefaultOverflowStrategyOverflowWithoutBufferSizeTest.getBaseArchive().addClasses(new Class[]{BeanUsingBufferOverflowWithoutBufferSizeStrategy.class})).addAsManifestResource((Asset)new StringAsset("mp.messaging.emitter.default-buffer-size=5"), "microprofile-config.properties");
    }

    @Test
    public void testOverflow() {
        this.bean.tryEmitThousand();
        Assertions.assertThat((int)(this.bean.accepted().size() + this.bean.rejected().size())).isEqualTo(1000);
        Assertions.assertThat(this.bean.rejected()).isNotEmpty();
        Assertions.assertThat(this.bean.accepted()).containsAll((Iterable)IntStream.range(0, 5).mapToObj(Integer::toString).collect(Collectors.toList()));
        Assertions.assertThat(this.bean.rejected()).containsAll((Iterable)IntStream.range(7, 1000).mapToObj(Integer::toString).collect(Collectors.toList()));
        Assertions.assertThat((Throwable)this.bean.failure()).isNull();
    }
}

