/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import jakarta.inject.Inject;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.api.LraCancelOnResource;
import org.eclipse.microprofile.lra.tck.service.LRAMetricAssertions;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckCancelOnTests
extends TckTestBase {
    @Inject
    private LRAMetricAssertions lraMetric;
    @Inject
    private LRATestService lraTestService;

    @Deployment(name="tcktests-cancelon")
    public static WebArchive deploy() {
        return TckTestBase.deploy(TckCancelOnTests.class.getSimpleName().toLowerCase());
    }

    private WebTarget getSuiteTarget() {
        return this.tckSuiteTarget;
    }

    @Test
    public void cancelOnFamilyDefault4xx() {
        WebTarget resourcePath = this.getSuiteTarget().path("lraresource-cancelon").path("cancelOnFamilyDefault4xx");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.BAD_REQUEST, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertCompensated("After 400 compensate should be invoked", lraId, LraCancelOnResource.class);
        this.lraMetric.assertNotCompleted("After 400 complete can't be invoked", lraId, LraCancelOnResource.class);
    }

    @Test
    public void cancelOnFamilyDefault5xx() {
        WebTarget resourcePath = this.getSuiteTarget().path("lraresource-cancelon").path("cancelOnFamilyDefault5xx");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.INTERNAL_SERVER_ERROR, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertCompensated("After 500 compensate should be invoked", lraId, LraCancelOnResource.class);
        this.lraMetric.assertNotCompleted("After 500 complete can't be invoked", lraId, LraCancelOnResource.class);
    }

    @Test
    public void cancelOnFamily3xx() {
        WebTarget resourcePath = this.getSuiteTarget().path("lraresource-cancelon").path("cancelOnFamily3xx");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.SEE_OTHER, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertCompensated("After status code 303 is received, compensate should be invoked as set by attribute cancelOnFamily", lraId, LraCancelOnResource.class);
        this.lraMetric.assertNotCompleted("After status code 303 is received, complete can't be invoked as not defined in annotation @LRA", lraId, LraCancelOnResource.class);
    }

    @Test
    public void cancelOn301() {
        WebTarget resourcePath = this.getSuiteTarget().path("lraresource-cancelon").path("cancelOn301");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.MOVED_PERMANENTLY, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertCompensated("After status code 301 is received, compensate should be invoked as set by attribute cancelOn", lraId, LraCancelOnResource.class);
        this.lraMetric.assertNotCompleted("After status code 301 is received, complete can't be invoked as not defined in annotation @LRA", lraId, LraCancelOnResource.class);
    }

    @Test
    public void notCancelOnFamily5xx() {
        WebTarget resourcePath = this.getSuiteTarget().path("lraresource-cancelon").path("notCancelOnFamily5xx");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.INTERNAL_SERVER_ERROR, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertNotCompensated("After status code 500 is received, compensate can't be invoked as the default behaviour has changed", lraId, LraCancelOnResource.class);
        this.lraMetric.assertCompleted("After status code 500 is received, complete has to be called as the default behaviour has changed", lraId, LraCancelOnResource.class);
    }

    @Test
    public void cancelFromRemoteCall() {
        WebTarget resourcePath = this.getSuiteTarget().path("lraresource-cancelon").path("cancelFromRemoteCall");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertCompensated("Status was 200 but compensate should be called as LRA should be cancelled for remotely called participant as well", lraId, LraCancelOnResource.class);
        this.lraMetric.assertNotCompleted("Even the 200 status was received the remotely called participant should cause the LRA being cancelled", lraId, LraCancelOnResource.class);
    }
}

