/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.UnsecureTCKApplication;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.UnsecuredPingEndpoint;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnsecuredPingTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL publicKey = UnsecuredPingTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"UnsecuredPingTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(UnsecuredPingEndpoint.class)).addClass(UnsecureTCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Basic test of an unsecured JAX-RS endpoint")
    public void callEchoNoAuth() throws Exception {
        String uri = this.baseURL.toExternalForm() + "ping/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }
}

