/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.Util;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.accessibility.AccessibleCompositeAdapter;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.mat.ui.snapshot.views.SnapshotOutlinePage;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SnapshotHistoryView
extends ViewPart
implements SnapshotHistoryService.IChangeListener {
    private Table table;
    private Action actionOpen;
    private Action actionRemoveFromList;
    private Action actionDelete;
    private Action actionOpenFileInFileSystem;
    private Action actionDeleteIndeces;
    private Action actionCopy;
    private LocalResourceManager resourceManager;
    private Font italicFont;

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66306);
        final TableColumn tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText(Messages.SnapshotHistoryView_RecentlyUsedFiles);
        tableColumn.setWidth(400);
        this.table.setHeaderVisible(true);
        AccessibleCompositeAdapter.access(this.table);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.table);
        this.italicFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(2));
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                tableColumn.setWidth(((SnapshotHistoryView)SnapshotHistoryView.this).table.getClientArea().width);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                SnapshotHistoryView.this.openFile(selection);
            }
        });
        this.fillTable();
        this.makeActions();
        this.hookContextMenu();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    SnapshotHistoryView.this.actionRemoveFromList.run();
                }
            }
        });
        OpenStrategy openHandler = new OpenStrategy((Control)this.table);
        openHandler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                SnapshotHistoryView.this.actionOpen.run();
            }
        });
        SnapshotHistoryService.getInstance().addChangeListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.workbench_heapdumphistory");
    }

    private void fillTable() {
        List<SnapshotHistoryService.Entry> lastFiles = SnapshotHistoryService.getInstance().getVisitedEntries();
        for (SnapshotHistoryService.Entry entry : lastFiles) {
            IContentType type;
            SnapshotInfo ifo;
            String prefix;
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(entry.getFilePath());
            tableItem.setData((Object)entry);
            File index = null;
            if (entry.getInfo() instanceof SnapshotInfo && (prefix = (ifo = (SnapshotInfo)entry.getInfo()).getPrefix()) != null) {
                index = new File(String.valueOf(prefix) + "index");
            }
            if (index == null || !index.exists()) {
                tableItem.setFont(this.italicFont);
            }
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileInputStream is = new FileInputStream(entry.getFilePath());){
                    type = Platform.getContentTypeManager().findContentTypeFor((InputStream)is, entry.getFilePath());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                type = null;
            }
            ImageDescriptor imageDescriptor = registry.getImageDescriptor(entry.getFilePath(), type);
            if (index == null || !index.exists()) {
                imageDescriptor = ImageDescriptor.createWithFlags((ImageDescriptor)imageDescriptor, (int)1);
            }
            tableItem.setImage(MemoryAnalyserPlugin.getDefault().getImage(imageDescriptor));
        }
    }

    private void makeActions() {
        this.actionOpen = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                SnapshotHistoryView.this.openFile(selection);
            }
        };
        this.actionOpen.setText(Messages.SnapshotHistoryView_Open);
        this.actionOpen.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/open_snapshot.gif"));
        this.actionRemoveFromList = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                ArrayList<Path> toDelete = new ArrayList<Path>(selection.length);
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    toDelete.add(new Path(((SnapshotHistoryService.Entry)item.getData()).getFilePath()));
                    ++n2;
                }
                for (Path path : toDelete) {
                    SnapshotHistoryService.getInstance().removePath((IPath)path);
                }
            }
        };
        this.actionRemoveFromList.setText(Messages.SnapshotHistoryView_RemoveFromList);
        this.actionRemoveFromList.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.actionDelete = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ArrayList<SnapshotHistoryService.Entry> toDelete = new ArrayList<SnapshotHistoryService.Entry>(selection.length);
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    toDelete.add((SnapshotHistoryService.Entry)item.getData());
                    ++n2;
                }
                String dialogTitle = toDelete.size() > 1 ? MessageUtil.format((String)Messages.SnapshotHistoryView_AreYouSure4ManyFiles, (Object[])new Object[]{toDelete.size()}) : MessageUtil.format((String)Messages.SnapshotHistoryView_AreYouSure4OneFile, (Object[])new Object[]{new File(((SnapshotHistoryService.Entry)toDelete.get(0)).getFilePath()).getAbsolutePath()});
                DeleteSnapshotDialog deleteSnapshotDialog = new DeleteSnapshotDialog(SnapshotHistoryView.this.table.getShell(), dialogTitle);
                int response = deleteSnapshotDialog.open();
                if (response != 0) {
                    return;
                }
                if (deleteSnapshotDialog.getDeleteInFileSystem()) {
                    ArrayList<File> problems = new ArrayList<File>();
                    for (SnapshotHistoryService.Entry entry : toDelete) {
                        SnapshotInfo ifo;
                        String prefix;
                        File path = new File(entry.getFilePath());
                        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new PathEditorInput((IPath)new Path(path.getAbsolutePath())));
                        if (editor != null) {
                            SnapshotHistoryView.this.getSite().getPage().closeEditor(editor, true);
                        }
                        File index = path;
                        if (entry.getInfo() instanceof SnapshotInfo && (prefix = (ifo = (SnapshotInfo)entry.getInfo()).getPrefix()) != null) {
                            index = new File(String.valueOf(prefix) + "index");
                            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new PathEditorInput((IPath)new Path(index.getAbsolutePath())));
                            if (editor != null) {
                                SnapshotHistoryView.this.getSite().getPage().closeEditor(editor, true);
                            }
                        }
                        if (!path.delete()) {
                            problems.add(path);
                        }
                        SnapshotHistoryView.this.deleteIndexes(index, problems);
                        if (!path.exists()) {
                            SnapshotHistoryService.getInstance().removePath((IPath)new Path(path.getAbsolutePath()));
                        }
                        if (index.exists()) continue;
                        SnapshotHistoryService.getInstance().removePath((IPath)new Path(index.getAbsolutePath()));
                    }
                    if (!problems.isEmpty()) {
                        SnapshotHistoryView.this.showProblems(problems);
                    } else {
                        MessageBox box = new MessageBox(SnapshotHistoryView.this.table.getShell(), 34);
                        box.setMessage(Messages.SnapshotHistoryView_DeleteInFileSystemSuccess);
                        box.open();
                    }
                } else {
                    for (SnapshotHistoryService.Entry entry : toDelete) {
                        File path = new File(entry.getFilePath());
                        SnapshotHistoryService.getInstance().removePath((IPath)new Path(path.getAbsolutePath()));
                    }
                }
            }
        };
        this.actionDelete.setText(Messages.SnapshotHistoryView_DeleteFile);
        this.actionDelete.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.actionOpenFileInFileSystem = new Action(){
            private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
            private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";
            private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                String filename = ((SnapshotHistoryService.Entry)selection[0].getData()).getFilePath();
                Path path = new Path(filename);
                final File file = path.toFile();
                if (file.exists()) {
                    try {
                        final String launchCmd = this.formShowInSystemExplorerCommand(file);
                        if ("".equals(launchCmd)) {
                            String osName = System.getProperty("os.name", "");
                            this.displayMessage(MessageUtil.format((String)Messages.SnapshotHistoryView_OperationNotImplemented, (Object[])new Object[]{osName}));
                            return;
                        }
                        Job job = new Job(Messages.SnapshotHistoryView_ExploreFileSystem){

                            protected IStatus run(IProgressMonitor monitor) {
                                block22: {
                                    try {
                                        InputStreamReader rd;
                                        Process p;
                                        int r;
                                        File dir = file.getParentFile();
                                        if (dir != null) {
                                            dir = dir.getCanonicalFile();
                                        }
                                        if ((r = (p = Util.isLinux() || Util.isMac() ? Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", launchCmd}, null, dir) : Runtime.getRuntime().exec(launchCmd, null, dir)).waitFor()) == 0) break block22;
                                        CharBuffer cb = CharBuffer.allocate(4096);
                                        cb.append(launchCmd);
                                        int pos = cb.position();
                                        cb.append('\n');
                                        Throwable throwable = null;
                                        Object var8_11 = null;
                                        try {
                                            rd = new InputStreamReader(p.getInputStream(), Charset.defaultCharset());
                                            try {
                                                ((Reader)rd).read(cb);
                                            }
                                            finally {
                                                if (rd != null) {
                                                    ((Reader)rd).close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                        cb.append('\n');
                                        throwable = null;
                                        var8_11 = null;
                                        try {
                                            rd = new InputStreamReader(p.getErrorStream(), Charset.defaultCharset());
                                            try {
                                                ((Reader)rd).read(cb);
                                            }
                                            finally {
                                                if (rd != null) {
                                                    ((Reader)rd).close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable == null) {
                                                throwable = throwable3;
                                            } else if (throwable != throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            throw throwable;
                                        }
                                        if (!Util.isWindows() || cb.position() > pos + 2) {
                                            cb.flip();
                                            return ErrorHelper.createErrorStatus(cb.toString());
                                        }
                                    }
                                    catch (IOException | InterruptedException ex) {
                                        return ErrorHelper.createErrorStatus(ex);
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    catch (IOException ex) {
                        ErrorHelper.showErrorMessage(ex);
                    }
                } else {
                    this.displayMessage(MessageUtil.format((String)Messages.SnapshotHistoryView_FileDoesNotExist, (Object[])new Object[]{file.getAbsolutePath()}));
                }
            }

            private void execute(String baseCommand, String osPath, File file) {
                try {
                    String forceDirectoryPath = osPath;
                    if (file.isFile()) {
                        forceDirectoryPath = file.getParentFile().getCanonicalPath();
                    }
                    Runtime.getRuntime().exec(new String[]{baseCommand, forceDirectoryPath});
                }
                catch (IOException ex) {
                    MemoryAnalyserPlugin.log(ex);
                }
            }

            private void displayMessage(String message) {
                MessageDialog.openInformation((Shell)SnapshotHistoryView.this.table.getParent().getShell(), (String)Messages.SnapshotHistoryView_ExploreFileSystem, (String)message);
            }

            private String formShowInSystemExplorerCommand(File path) throws IOException {
                String command = Platform.getPreferencesService().getString("org.eclipse.ui.ide", "SYSTEM_EXPLORER", this.getShowInSystemExplorerCommand(), null);
                command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)this.quotePath(path.getCanonicalPath()));
                command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)path.getCanonicalFile().toURI().toString());
                File parent = path.getParentFile();
                if (parent != null) {
                    command = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)this.quotePath(parent.getCanonicalPath()));
                }
                return command;
            }

            private String quotePath(String path) {
                if (Util.isLinux() || Util.isMac()) {
                    path = path.replaceAll("[\"$`]", "\\\\$0");
                }
                return path;
            }

            public String getShowInSystemExplorerCommand() {
                if (Util.isGtk()) {
                    return "dbus-send --print-reply --dest=org.freedesktop.FileManager1 /org/freedesktop/FileManager1 org.freedesktop.FileManager1.ShowItems array:string:\"${selected_resource_uri}\" string:\"\"";
                }
                if (Util.isWindows()) {
                    return "explorer /E,/select=${selected_resource_loc}";
                }
                if (Util.isMac()) {
                    return "open -R \"${selected_resource_loc}\"";
                }
                return "";
            }
        };
        this.actionOpenFileInFileSystem.setText(Messages.SnapshotHistoryView_ExploreInFileSystem);
        this.actionOpenFileInFileSystem.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/explore.gif"));
        this.actionDeleteIndeces = new Action(Messages.SnapshotHistoryView_DeleteIndexFiles){

            public void run() {
                ArrayList problems = new ArrayList();
                TableItem[] tableItemArray = SnapshotHistoryView.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SnapshotInfo ifo;
                    String prefix;
                    File snapshot;
                    TableItem item = tableItemArray[n2];
                    SnapshotHistoryService.Entry entry = (SnapshotHistoryService.Entry)item.getData();
                    File index = snapshot = new File(entry.getFilePath());
                    if (entry.getInfo() instanceof SnapshotInfo && (prefix = (ifo = (SnapshotInfo)entry.getInfo()).getPrefix()) != null) {
                        index = new File(String.valueOf(prefix) + "index");
                        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new PathEditorInput((IPath)new Path(index.getAbsolutePath())));
                        if (editor != null) {
                            SnapshotHistoryView.this.getSite().getPage().closeEditor(editor, true);
                        }
                    }
                    SnapshotHistoryView.this.deleteIndexes(index, problems);
                    if (!index.exists()) {
                        item.setFont(SnapshotHistoryView.this.italicFont);
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)item.getImage());
                        imageDescriptor = ImageDescriptor.createWithFlags((ImageDescriptor)imageDescriptor, (int)1);
                        item.setImage(MemoryAnalyserPlugin.getDefault().getImage(imageDescriptor));
                        SnapshotHistoryService.getInstance().removePath((IPath)new Path(index.getAbsolutePath()));
                    }
                    ++n2;
                }
                if (!problems.isEmpty()) {
                    SnapshotHistoryView.this.showProblems(problems);
                } else {
                    MessageBox box = new MessageBox(SnapshotHistoryView.this.table.getShell(), 34);
                    box.setMessage(Messages.SnapshotHistoryView_DeleteIndexFilesSuccess);
                    box.open();
                }
            }
        };
        this.actionDeleteIndeces.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/removeall.gif"));
        this.actionCopy = new Action(){

            public void run() {
                StringBuilder selectedItems = new StringBuilder();
                TableItem[] tableItemArray = SnapshotHistoryView.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String path;
                    TableItem selected = tableItemArray[n2];
                    if (selectedItems.length() > 0) {
                        selectedItems.append(' ');
                    }
                    if ((path = selected.getText()).indexOf(32) != -1) {
                        path = String.valueOf('\"') + path + '\"';
                    }
                    selectedItems.append(path);
                    ++n2;
                }
                if (selectedItems.length() > 0) {
                    Copy.copyToClipboard(selectedItems.toString(), SnapshotHistoryView.this.table.getDisplay());
                }
            }
        };
        this.actionCopy.setText(Messages.SnapshotHistoryView_CopyFilename);
        this.actionCopy.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/copy.gif"));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.actionCopy);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SnapshotHistoryView.this.editorContextMenuAboutToShow(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    private void editorContextMenuAboutToShow(IMenuManager manager) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return;
        }
        this.actionOpen.setEnabled(selection.length == 1);
        manager.add((IAction)this.actionOpen);
        this.actionOpenFileInFileSystem.setEnabled(selection.length == 1);
        manager.add((IAction)this.actionOpenFileInFileSystem);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionDeleteIndeces);
    }

    public void dispose() {
        super.dispose();
        SnapshotHistoryService.getInstance().removeChangeListener(this);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public <T> T getAdapter(Class<T> required) {
        if (IContentOutlinePage.class.equals(required)) {
            return required.cast((Object)new Outline());
        }
        return (T)super.getAdapter(required);
    }

    @Override
    public void onFileHistoryChange(List<SnapshotHistoryService.Entry> visited) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SnapshotHistoryView.this.table.removeAll();
                SnapshotHistoryView.this.fillTable();
            }
        });
    }

    private void openFile(TableItem[] selection) {
        if (selection.length == 1) {
            String prefix;
            String index;
            Path path2;
            SnapshotInfo info;
            SnapshotHistoryService.Entry entry = (SnapshotHistoryService.Entry)selection[0].getData();
            Path path = new Path(entry.getFilePath());
            Serializable ss = entry.getInfo();
            if (ss instanceof SnapshotInfo && (info = (SnapshotInfo)ss).getProperty("$runtimeId") != null && (path2 = new Path(index = String.valueOf(prefix = info.getPrefix()) + "index")).toFile().exists()) {
                path = path2;
            }
            if (path.toFile().exists()) {
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new PathEditorInput((IPath)path), (String)entry.getEditorId(), (boolean)true);
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            } else {
                MessageDialog.openError((Shell)this.table.getParent().getShell(), (String)Messages.SnapshotHistoryView_FileDoesNotExistAnymore, (String)MessageUtil.format((String)Messages.SnapshotHistoryView_SelectedFileDoesNotExist, (Object[])new Object[]{path.toOSString()}));
                SnapshotHistoryService.getInstance().removePath((IPath)path);
            }
        }
    }

    private void deleteIndexes(File snapshot, List<File> problems) {
        Pattern pattern;
        String name;
        int lastDot;
        String prefix;
        File directory = snapshot.getParentFile();
        String[] indexFiles = directory.list(new FilenameFilter(prefix = (lastDot = (name = snapshot.getName()).lastIndexOf(46)) >= 0 ? name.substring(0, lastDot) : name, pattern = Pattern.compile("\\.(([A-Za-z0-9]{1,20}\\.)?index|threads)$")){
            private final /* synthetic */ String val$prefix;
            private final /* synthetic */ Pattern val$pattern;
            {
                this.val$prefix = string;
                this.val$pattern = pattern;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(this.val$prefix) && this.val$pattern.matcher(name.substring(this.val$prefix.length())).matches();
            }
        });
        if (indexFiles != null) {
            String[] stringArray = indexFiles;
            int n = indexFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String indexFile = stringArray[n2];
                File f = new File(directory, indexFile);
                if (f.exists() && !f.delete() && problems != null) {
                    problems.add(f);
                }
                ++n2;
            }
        }
    }

    private void showProblems(List<File> problems) {
        StringBuilder msg = new StringBuilder();
        msg.append(Messages.SnapshotHistoryView_ErrorDeletingFiles);
        for (File f : problems) {
            msg.append("\n\t").append(f.getAbsolutePath());
        }
        MessageBox box = new MessageBox(this.table.getShell(), 33);
        box.setMessage(msg.toString());
        box.open();
    }

    private static class DeleteSnapshotDialog
    extends MessageDialog {
        private boolean deleteInFileSystem = false;
        private Button deleteRadio;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    deleteInFileSystem = button == deleteRadio;
                }
            }
        };

        public DeleteSnapshotDialog(Shell parentShell, String dialogTitle) {
            super(parentShell, Messages.SnapshotHistoryView_ConfirmDeletion, null, dialogTitle, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.deleteRadio = new Button(composite, 16);
            this.deleteRadio.addSelectionListener(this.selectionListener);
            this.deleteRadio.setText(Messages.SnapshotHistoryView_DeleteInFileSystem);
            this.deleteRadio.setFont(parent.getFont());
            Button radio = new Button(composite, 16);
            radio.addSelectionListener(this.selectionListener);
            radio.setText(Messages.SnapshotHistoryView_DeleteFromHistory);
            radio.setFont(parent.getFont());
            this.deleteRadio.setSelection(this.deleteInFileSystem);
            radio.setSelection(!this.deleteInFileSystem);
            return composite;
        }

        boolean getDeleteInFileSystem() {
            return this.deleteInFileSystem;
        }
    }

    private class Outline
    extends SnapshotOutlinePage
    implements SelectionListener {
        SnapshotHistoryService.Entry current;

        public Outline() {
            SnapshotHistoryView.this.table.addSelectionListener((SelectionListener)this);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            SnapshotHistoryService.Entry newEntry;
            SnapshotHistoryService.Entry entry = newEntry = e.item != null ? (SnapshotHistoryService.Entry)((TableItem)e.item).getData() : null;
            if (newEntry != null) {
                if (!newEntry.equals(this.current)) {
                    this.current = newEntry;
                }
                this.updateSnapshotInput();
            } else {
                this.current = null;
                this.updateSnapshotInput();
            }
        }

        @Override
        protected SnapshotInfo getBaseline() {
            return null;
        }

        @Override
        protected SnapshotInfo getSnapshot() {
            return this.current != null && this.current.getInfo() instanceof SnapshotInfo ? (SnapshotInfo)this.current.getInfo() : null;
        }

        @Override
        protected IPath getSnapshotPath() {
            return this.current != null ? new Path(this.current.getFilePath()) : null;
        }

        public void dispose() {
            SnapshotHistoryView.this.table.removeSelectionListener((SelectionListener)this);
            super.dispose();
        }
    }
}

