/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class SetFromCollectionExtractor
implements IMapExtractor {
    ICollectionExtractor ex;
    final Double collisionRatio;

    public SetFromCollectionExtractor(ICollectionExtractor ex) {
        this.ex = ex;
        this.collisionRatio = null;
    }

    public SetFromCollectionExtractor(ICollectionExtractor ex, double collisionRatio) {
        this.ex = ex;
        this.collisionRatio = collisionRatio;
    }

    @Override
    public boolean hasCollisionRatio() {
        return this.collisionRatio != null;
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        return this.collisionRatio;
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject collection) throws SnapshotException {
        final int[] objs = this.extractEntryIds(collection);
        final ISnapshot snapshot = collection.getSnapshot();
        return new Iterator<Map.Entry<IObject, IObject>>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < objs.length;
            }

            @Override
            public Map.Entry<IObject, IObject> next() {
                if (this.hasNext()) {
                    IObject value;
                    int ii = this.i++;
                    try {
                        value = snapshot.getObject(objs[ii]);
                    }
                    catch (SnapshotException e) {
                        NoSuchElementException ise = new NoSuchElementException();
                        ise.initCause(e);
                        throw ise;
                    }
                    return new Map.Entry<IObject, IObject>(){

                        @Override
                        public IObject getKey() {
                            return value;
                        }

                        @Override
                        public IObject getValue() {
                            return value;
                        }

                        @Override
                        public IObject setValue(IObject value2) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean hasSize() {
        return this.ex.hasSize();
    }

    @Override
    public Integer getSize(IObject collection) throws SnapshotException {
        return this.ex.getSize(collection);
    }

    @Override
    public boolean hasCapacity() {
        return this.ex.hasCapacity();
    }

    @Override
    public Integer getCapacity(IObject collection) throws SnapshotException {
        return this.ex.getCapacity(collection);
    }

    @Override
    public boolean hasFillRatio() {
        return this.ex.hasFillRatio();
    }

    @Override
    public Double getFillRatio(IObject collection) throws SnapshotException {
        return this.ex.getFillRatio(collection);
    }

    @Override
    public boolean hasExtractableContents() {
        return this.ex.hasExtractableContents();
    }

    @Override
    public int[] extractEntryIds(IObject collection) throws SnapshotException {
        return this.ex.extractEntryIds(collection);
    }

    @Override
    public boolean hasExtractableArray() {
        return this.ex.hasExtractableArray();
    }

    @Override
    public IObjectArray extractEntries(IObject collection) throws SnapshotException {
        return this.ex.extractEntries(collection);
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        return this.ex.getNumberOfNotNullElements(collection);
    }
}

