/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Arrays;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.HashMapCollectionExtractor;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="map_collision_ratio")
@Icon(value="/META-INF/icons/map_collision.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"java.util.AbstractMap", "java.util.jar.Attributes", "java.util.Dictionary", "java.lang.ThreadLocal$ThreadLocalMap", "java.util.concurrent.ConcurrentHashMap$Segment", "java.util.concurrent.ConcurrentHashMap$CollectionView", "java.util.Collections$SynchronizedMap", "java.util.Collections$UnmodifiableMap", "java.util.Collections$CheckedMap", "java.util.Collections$EmptyMap", "java.util.ResourceBundle", "java.awt.RenderingHints", "sun.awt.WeakIdentityHashMap", "javax.script.SimpleBindings", "javax.management.openmbean.TabularDataSupport", "com.ibm.jvm.util.HashMapRT", "com.sap.engine.lib.util.AbstractDataStructure", "org.eclipse.mat.collect.HashMapIntLong", "org.eclipse.mat.collect.HashMapIntObject", "org.eclipse.mat.collect.HashMapLongObject", "org.eclipse.mat.collect.HashMapObjectLong", "java.util.HashSet", "java.util.Collections$SetFromMap", "java.util.Properties$EntrySet", "java.util.Collections$EmptySet"})
public class MapCollisionRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public int segments = 5;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;
    @Argument(isMandatory=false)
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.MapCollisionRatioQuery_CalculatingCollisionRatios);
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)Messages.MapCollisionRatioQuery_Column_CollisionRatio, (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column(Messages.MapCollisionRatioQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_BYTES);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        HashMapCollectionExtractor specificExtractor = new HashMapCollectionExtractor(this.size_attribute, this.array_attribute, null, null);
        long LIMIT = 20L;
        HashMapIntLong exceptions = new HashMapIntLong();
        int counter = 0;
        IClass type = null;
        for (int[] objectIds : this.objects) {
            int objectId;
            HashMapIntObject resultMap = null;
            int[] sortedObjs = objectIds;
            int prev = Integer.MIN_VALUE;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (objectId < prev) {
                    sortedObjs = (int[])objectIds.clone();
                    Arrays.sort(sortedObjs);
                    resultMap = new HashMapIntObject();
                    break;
                }
                prev = objectId;
                ++n2;
            }
            nArray = sortedObjs;
            n = sortedObjs.length;
            n2 = 0;
            while (n2 < n) {
                block15: {
                    objectId = nArray[n2];
                    if (listener.isCanceled()) break;
                    IObject obj = this.snapshot.getObject(objectId);
                    if (counter++ % 1000 == 0 && !obj.getClazz().equals(type)) {
                        type = obj.getClazz();
                        listener.subTask(String.valueOf(Messages.MapCollisionRatioQuery_CalculatingCollisionRatios) + "\n" + type.getName());
                    }
                    try {
                        ExtractedMap coll = CollectionExtractionUtils.extractMap(obj, this.collection, specificExtractor);
                        if (coll != null) {
                            coll.hasCollisionRatio();
                            Double collisionRatio = coll.getCollisionRatio();
                            if (collisionRatio == null) {
                                collisionRatio = 0.0;
                            }
                            if (resultMap != null) {
                                resultMap.put(objectId, (Object)new Result(collisionRatio, coll.getUsedHeapSize()));
                            } else {
                                quantize.addValue(objectId, new Object[]{collisionRatio, null, coll.getUsedHeapSize()});
                            }
                        }
                    }
                    catch (RuntimeException | SnapshotException e) {
                        int classId = obj.getClazz().getObjectId();
                        if (!exceptions.containsKey(classId)) {
                            exceptions.put(classId, 0L);
                        }
                        long c = exceptions.get(classId);
                        exceptions.put(classId, c + 1L);
                        if (c >= 20L) break block15;
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.MapCollisionRatioQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), e);
                    }
                }
                ++n2;
            }
            if (resultMap != null) {
                nArray = objectIds;
                n = objectIds.length;
                n2 = 0;
                while (n2 < n) {
                    objectId = nArray[n2];
                    if (resultMap.containsKey(objectId)) {
                        Result r = (Result)resultMap.get(objectId);
                        quantize.addValue(objectId, new Object[]{r.ratio, null, r.used});
                    }
                    ++n2;
                }
            }
            if (listener.isCanceled()) break;
        }
        return quantize.getResult();
    }

    private static class Result {
        final double ratio;
        final long used;

        public Result(double ratio, long used) {
            this.ratio = ratio;
            this.used = used;
        }
    }
}

