/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.rename;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.m2e.refactoring.internal.SaveDirtyFilesDialog;
import org.eclipse.m2e.refactoring.rename.MavenRenameWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameArtifactHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(RenameArtifactHandler.class);

    public Object execute(ExecutionEvent event) {
        ISelection selection = this.computeSelection(event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IFile var4_5) {
            this.rename((IFile)file);
        } else {
            if (element instanceof IAdaptable var6_7) {
                IProject project = (IProject)adaptable.getAdapter(IProject.class);
                if (project == null) {
                    return null;
                }
                IFile file = project.getFile("pom.xml");
                if (file != null) {
                    this.rename(file);
                }
            }
        }
        return null;
    }

    private void rename(IFile file) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean rc = SaveDirtyFilesDialog.saveDirtyFiles("pom.xml");
            if (!rc) {
                return;
            }
            MavenRenameWizard wizard = new MavenRenameWizard(file);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            String titleForFailedChecks = "";
            op.run(shell, titleForFailedChecks);
        }
        catch (Exception e) {
            log.error("Unable to rename " + file, (Throwable)e);
        }
    }

    protected ISelection computeSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            selection = HandlerUtil.getActiveMenuEditorInput((ExecutionEvent)event);
        }
        if (!(selection instanceof IStructuredSelection)) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (!(selection instanceof IStructuredSelection)) {
            selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        }
        return selection;
    }
}

