/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowLink;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowNode;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;

public class TransformUtil {
    public static boolean isValidFacesConfigElement(EObject object) {
        EObject parent = EcoreUtil.getRootContainer((EObject)object);
        boolean result = parent instanceof FacesConfigType;
        return result;
    }

    public static boolean isValidPageflowElement(EObject element) {
        EObject root = EcoreUtil.getRootContainer((EObject)element);
        boolean result = root instanceof Pageflow;
        return result;
    }

    public static boolean isValidLink(PageflowLink link) {
        return TransformUtil.isValidPageflowElement(link) && link.getSource() != null && link.getTarget() != null;
    }

    public static String getFromViewID(NavigationRuleType rule) {
        String result = "*";
        if (rule.getFromViewId() != null) {
            result = rule.getFromViewId().getTextContent();
        }
        return result;
    }

    public static String getToViewID(NavigationCaseType navCase) {
        String result = "*";
        if (navCase.getToViewId() != null) {
            result = navCase.getToViewId().getTextContent();
        }
        return result;
    }

    public static PageflowPage findPage(String path, Pageflow pageflow) {
        EList nodes = pageflow.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            if (nodes.get(i) instanceof PageflowPage && path != null && path.equals(((PageflowPage)nodes.get(i)).getPath())) {
                return (PageflowPage)nodes.get(i);
            }
            ++i;
        }
        return null;
    }

    public static PageflowNode findCaseEnd(PageflowPage action, FromOutcomeType outcome, Pageflow pageflow) {
        EList links = action.getOutlinks();
        int i = 0;
        while (i < links.size()) {
            PageflowLink link = (PageflowLink)links.get(i);
            String outcomeStr = "";
            if (outcome != null) {
                outcomeStr = outcome.getTextContent();
            }
            if (link.getOutcome().equals(outcomeStr)) {
                return link.getTarget();
            }
            ++i;
        }
        return null;
    }
}

