/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.utils;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import io.smallrye.common.expression.Expression;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.lsp4mp.commons.utils.IConfigSourcePropertiesProvider;

public class PropertyValueExpander {
    private static final Logger LOGGER = Logger.getLogger(PropertyValueExpander.class.getName());
    private static final long REFERENCE_UPPER_BOUND = 1000000L;
    private final PropertyGraph propertyGraph;
    private final IConfigSourcePropertiesProvider properties;
    private final Map<String, ResolvedPropertyValueInformation> resolved;

    public PropertyValueExpander(IConfigSourcePropertiesProvider properties) {
        this.properties = properties;
        this.propertyGraph = new PropertyGraph(properties);
        this.resolved = new HashMap<String, ResolvedPropertyValueInformation>();
    }

    public String getValue(String key) {
        if (this.propertyGraph.isAcyclic()) {
            ResolvedPropertyValueInformation info = this.getResolvedValue(key);
            return info == null ? null : info.getValue();
        }
        return this.properties.getValue(key);
    }

    public List<String> getIndependentProperties(String property) {
        return this.propertyGraph.getIndependentProperties(property);
    }

    private ResolvedPropertyValueInformation getResolvedValue(String key) {
        if (!this.properties.hasKey(key)) {
            return null;
        }
        if (this.resolved.get(key) != null) {
            return this.resolved.get(key);
        }
        Counter referenceCounter = new Counter();
        String unresolvedValue = this.properties.getValue(key);
        Expression expr = Expression.compile((String)unresolvedValue, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX});
        String resolvedValue = expr.evaluate((context, builder) -> {
            referenceCounter.add(1L);
            ResolvedPropertyValueInformation referencedKeyValueInformation = this.getResolvedValue(context.getKey());
            if (referencedKeyValueInformation == null || referencedKeyValueInformation.getValue() == null) {
                if (context.hasDefault()) {
                    context.expandDefault();
                } else {
                    builder.append("${" + context.getKey() + "}");
                }
            } else if (referencedKeyValueInformation.getExpansions() >= 1000000L) {
                referenceCounter.add(1000000L);
                LOGGER.warning(MessageFormat.format("Property expression expansion for key `{0}` has exceeded 1 million references, and as such, will not be attempted", key));
            } else {
                referenceCounter.add(referencedKeyValueInformation.getExpansions());
                builder.append(referencedKeyValueInformation.getValue());
            }
        });
        ResolvedPropertyValueInformation resolvedInfo = null;
        if (referenceCounter.getValue() >= 1000000L) {
            resolvedInfo = new ResolvedPropertyValueInformation(unresolvedValue, referenceCounter.getValue());
            this.resolved.put(key, resolvedInfo);
        } else if (resolvedValue != null && resolvedValue.length() > 0) {
            resolvedInfo = new ResolvedPropertyValueInformation(resolvedValue, referenceCounter.getValue());
            this.resolved.put(key, resolvedInfo);
        }
        return resolvedInfo;
    }

    private static class Counter {
        private long value = 0L;

        Counter() {
        }

        void add(long amt) {
            this.value += amt;
        }

        long getValue() {
            return this.value;
        }
    }

    private static class PropertyGraph {
        private Graph<String> graph;
        private Optional<Boolean> acyclic;

        PropertyGraph(IConfigSourcePropertiesProvider properties) {
            MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(true).build();
            this.acyclic = Optional.empty();
            for (String key : properties.keys()) {
                graph.addNode((Object)key);
            }
            for (String key : properties.keys()) {
                String unresolvedValue = properties.getValue(key);
                if (!unresolvedValue.contains("${")) continue;
                Expression expr = Expression.compile((String)unresolvedValue, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX});
                expr.evaluate((resolver, builder) -> {
                    if (graph.nodes().contains(resolver.getKey())) {
                        graph.putEdge((Object)key, (Object)resolver.getKey());
                    }
                    resolver.expandDefault();
                });
            }
            this.graph = graph;
        }

        boolean isAcyclic() {
            if (!this.acyclic.isPresent()) {
                this.acyclic = Optional.of(!Graphs.hasCycle(this.graph));
            }
            return this.acyclic.get();
        }

        public List<String> getIndependentProperties(String property) {
            Graph<String> reversed = this.getReversed();
            HashSet<String> reachable = new HashSet<String>();
            ArrayList<String> unreachable = new ArrayList<String>(this.graph.nodes().size());
            for (String reached : Traverser.forGraph(reversed).breadthFirst((Object)property)) {
                reachable.add(reached);
            }
            for (String node : this.graph.nodes()) {
                if (reachable.contains(node)) continue;
                unreachable.add(node);
            }
            return unreachable;
        }

        private Graph<String> getReversed() {
            MutableGraph mutableReversed = GraphBuilder.directed().allowsSelfLoops(true).build();
            for (String node : this.graph.nodes()) {
                mutableReversed.addNode((Object)node);
            }
            for (EndpointPair edge : this.graph.edges()) {
                mutableReversed.putEdge((Object)((String)edge.nodeV()), (Object)((String)edge.nodeU()));
            }
            return mutableReversed;
        }
    }

    private static class ResolvedPropertyValueInformation {
        private long expansions;
        private String value;

        ResolvedPropertyValueInformation(String value, long expansions) {
            this.value = value;
            this.expansions = expansions;
        }

        String getValue() {
            return this.value;
        }

        long getExpansions() {
            return this.expansions;
        }
    }
}

