/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.properties;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileConfigPropertyProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final String[] ANNOTATION_NAMES = new String[]{"org.eclipse.microprofile.config.inject.ConfigProperty"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation configPropertyAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() == 8 || javaElement.getElementType() == 14) {
            IPropertiesCollector collector = context.getCollector();
            String name = AnnotationUtils.getAnnotationMemberValue(configPropertyAnnotation, "name");
            if (name != null && !name.isEmpty()) {
                IJavaProject javaProject = javaElement.getJavaProject();
                String varTypeName = JDTTypeUtils.getResolvedTypeName(javaElement);
                IType varType = JDTTypeUtils.findType(javaProject, varTypeName);
                String type = JDTTypeUtils.getPropertyType(varType, varTypeName);
                String description = null;
                String sourceType = JDTTypeUtils.getSourceType(javaElement);
                String sourceField = null;
                String sourceMethod = null;
                String defaultValue = AnnotationUtils.getAnnotationMemberValue(configPropertyAnnotation, "defaultValue");
                String extensionName = null;
                if (javaElement.getElementType() == 8) {
                    sourceField = JDTTypeUtils.getSourceField(javaElement);
                } else if (javaElement.getElementType() == 14) {
                    ILocalVariable localVariable = (ILocalVariable)javaElement;
                    IMethod method = (IMethod)localVariable.getDeclaringMember();
                    sourceMethod = JDTTypeUtils.getSourceMethod(method);
                }
                IType enclosedType = JDTTypeUtils.getEnclosedType(varType, type, javaProject);
                super.updateHint(collector, enclosedType);
                boolean binary = JDTTypeUtils.isBinary(javaElement);
                this.addItemMetadata(collector, name, type, description, sourceType, sourceField, sourceMethod, defaultValue, extensionName, binary);
            }
        }
    }
}

