/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.corrections;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;

public class DiagnosticsHelper {
    public static int getEndOffset(ICompilationUnit unit, Range range, IJDTUtils utils) {
        try {
            return utils.toOffset(unit.getBuffer(), range.getEnd().getLine(), range.getEnd().getCharacter());
        }
        catch (JavaModelException javaModelException) {
            return -1;
        }
    }

    public static int getStartOffset(ICompilationUnit unit, Range range, IJDTUtils utils) {
        try {
            return utils.toOffset(unit.getBuffer(), range.getStart().getLine(), range.getStart().getCharacter());
        }
        catch (JavaModelException javaModelException) {
            return -1;
        }
    }

    public static int getLength(ICompilationUnit unit, Range range, IJDTUtils utils) {
        int start = DiagnosticsHelper.getStartOffset(unit, range, utils);
        int end = DiagnosticsHelper.getEndOffset(unit, range, utils);
        return end - start;
    }
}

