/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.definition;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.jdt.core.java.definition.AbstractAnnotationDefinitionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.definition.JavaDefinitionContext;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;

public class PropertiesDefinitionParticipant
extends AbstractAnnotationDefinitionParticipant {
    public PropertiesDefinitionParticipant(String annotationName, String[] annotationAttributeNames) {
        super(annotationName, annotationAttributeNames);
    }

    public PropertiesDefinitionParticipant(String annotationName, String[] annotationAttributeNames, Function<String, String> propertyReplacer) {
        super(annotationName, annotationAttributeNames, propertyReplacer);
    }

    @Override
    protected List<MicroProfileDefinition> collectDefinitions(String propertyKey, Range propertyKeyRange, IAnnotation annotation, JavaDefinitionContext context, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject javaProject = context.getJavaProject();
        List<MicroProfileConfigPropertyInformation> infos = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject).getPropertyInformations(propertyKey);
        if (!infos.isEmpty()) {
            return infos.stream().map(info -> {
                MicroProfileDefinition definition = new MicroProfileDefinition();
                definition.setSelectPropertyName(info.getPropertyNameWithProfile());
                LocationLink location = new LocationLink();
                definition.setLocation(location);
                location.setTargetUri(info.getSourceConfigFileURI());
                location.setOriginSelectionRange(propertyKeyRange);
                return definition;
            }).collect(Collectors.toList());
        }
        return null;
    }
}

