/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PropertiesManagerLocationTest
extends BasePropertiesManagerTest {
    @BeforeClass
    public static void setupTests() throws Exception {
        BasePropertiesManagerTest.loadJavaProjects(new String[]{"maven/" + BasePropertiesManagerTest.MicroProfileMavenProjectName.using_vertx, "maven/" + BasePropertiesManagerTest.MicroProfileMavenProjectName.config_properties, "maven/" + BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart});
    }

    @Test
    public void usingVertxTest() throws Exception {
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.using_vertx);
        Location location = PropertiesManager.getInstance().findPropertyLocation(javaProject, "org.acme.vertx.FruitResource", "schemaCreate", null, JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"Definition from Java Sources", (Object)location);
    }

    @Test
    public void configPropertiesTest() throws Exception {
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_properties);
        Location location = PropertiesManager.getInstance().findPropertyLocation(javaProject, "org.acme.config.IGreetingConfiguration", null, "getName()QOptional<QString;>;", JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"Definition from IGreetingConfiguration#getName() method", (Object)location);
    }

    @Test
    public void configPropertiesMethodTest() throws Exception {
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        Location location = PropertiesManager.getInstance().findPropertyLocation(javaProject, "org.acme.config.GreetingMethodResource", null, "setMessage(QString;)V", JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"Definition from GreetingMethodResource#setMessage() method", (Object)location);
    }

    @Test
    public void configPropertiesConstructorTest() throws Exception {
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.config_quickstart);
        Location location = PropertiesManager.getInstance().findPropertyLocation(javaProject, "org.acme.config.GreetingConstructorResource", null, "GreetingConstructorResource(QString;QString;QOptional<QString;>;)V", JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((String)"Definition from GreetingConstructorResource constructor", (Object)location);
    }

    @Test
    public void nonExistantFieldTest() throws Exception {
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)BasePropertiesManagerTest.MicroProfileMavenProjectName.using_vertx);
        Location location = PropertiesManager.getInstance().findPropertyLocation(javaProject, "org.acme.vertx.Fruit", "Banana", null, JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNull((Object)location);
    }
}

