/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.faulttolerance.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class MicroProfileFaultToleranceProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileFaultToleranceProvider.class.getName());
    private static final String MICROPROFILE_FAULT_TOLERANCE_CONTEXT_KEY = String.valueOf(MicroProfileFaultToleranceProvider.class.getName()) + "#MicroProfileFaultToleranceContext";
    private static final String[] ANNOTATION_NAMES = new String[]{"org.eclipse.microprofile.faulttolerance.Asynchronous", "org.eclipse.microprofile.faulttolerance.Bulkhead", "org.eclipse.microprofile.faulttolerance.CircuitBreaker", "org.eclipse.microprofile.faulttolerance.Fallback", "org.eclipse.microprofile.faulttolerance.Retry", "org.eclipse.microprofile.faulttolerance.Timeout"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    private void collectProperties(IPropertiesCollector collector, AnnotationInfo info, IMember annotatedClassOrMethod, IAnnotation mpftAnnotation, MicroProfileFaultToleranceContext mpftContext) throws JavaModelException {
        String annotationName = info.getSimpleName();
        String className = null;
        String methodName = null;
        boolean binary = false;
        String sourceType = null;
        String sourceMethod = null;
        if (annotatedClassOrMethod != null) {
            binary = annotatedClassOrMethod.isBinary();
            switch (annotatedClassOrMethod.getElementType()) {
                case 7: {
                    IType annotatedClass = (IType)annotatedClassOrMethod;
                    className = annotatedClass.getFullyQualifiedName();
                    if (MicroProfileFaultToleranceProvider.isProcessed(className, annotationName, mpftContext)) {
                        return;
                    }
                    sourceType = JDTTypeUtils.getPropertyType(annotatedClass, className);
                    break;
                }
                case 9: {
                    IMethod annotatedMethod = (IMethod)annotatedClassOrMethod;
                    className = annotatedMethod.getDeclaringType().getFullyQualifiedName();
                    methodName = annotatedMethod.getElementName();
                    sourceType = JDTTypeUtils.getSourceType((IMember)annotatedMethod);
                    sourceMethod = JDTTypeUtils.getSourceMethod(annotatedMethod);
                }
            }
        } else if (MicroProfileFaultToleranceProvider.isProcessed(null, annotationName, mpftContext)) {
            return;
        }
        String prefix = MicroProfileFaultToleranceProvider.createPrefix(className, methodName, annotationName);
        List<AnnotationParameter> parameters = info.getParameters();
        for (AnnotationParameter parameter : parameters) {
            String propertyName = prefix + '/' + parameter.getName();
            String parameterType = parameter.getType();
            String description = parameter.getDescription();
            String defaultValue = MicroProfileFaultToleranceProvider.getParameterDefaultValue(parameter, mpftAnnotation);
            String extensionName = null;
            if (annotatedClassOrMethod == null) {
                sourceType = parameter.getSourceType();
                sourceMethod = parameter.getSourceMethod();
            }
            IType jdtType = parameter.getJDTType();
            super.updateHint(collector, jdtType);
            super.addItemMetadata(collector, propertyName, parameterType, description, sourceType, null, sourceMethod, defaultValue, extensionName, binary);
        }
    }

    private static boolean isProcessed(String className, String annotationName, MicroProfileFaultToleranceContext mpftContext) {
        if (mpftContext.isProcessed(className, annotationName)) {
            return true;
        }
        mpftContext.setProcessed(className, annotationName);
        return false;
    }

    private static String getParameterDefaultValue(AnnotationParameter parameter, IAnnotation mpftAnnotation) throws JavaModelException {
        String defaultValue = mpftAnnotation != null ? AnnotationUtils.getAnnotationMemberValue(mpftAnnotation, parameter.getName()) : null;
        return defaultValue != null ? defaultValue : parameter.getDefaultValue();
    }

    private static String createPrefix(String className, String methodName, String annotationName) {
        if (className == null && methodName == null) {
            return annotationName;
        }
        StringBuilder prefix = new StringBuilder();
        if (className != null) {
            prefix.append(className).append('/');
        }
        if (methodName != null) {
            prefix.append(methodName).append('/');
        }
        prefix.append(annotationName);
        return prefix.toString();
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation mpftAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (!(javaElement instanceof IMember)) {
            return;
        }
        MicroProfileFaultToleranceContext mpftContext = MicroProfileFaultToleranceProvider.getMicroProfileFaultToleranceContext(context);
        AnnotationInfo info = mpftContext.getAnnotationInfo(annotationName, monitor);
        if (info != null) {
            this.collectProperties(context.getCollector(), info, null, null, mpftContext);
            mpftContext.addFaultToleranceProperties(context.getCollector());
            if (javaElement.getElementType() == 9) {
                IMethod annotatedMethod = (IMethod)javaElement;
                IType classType = annotatedMethod.getDeclaringType();
                IAnnotation mpftAnnotationForClass = AnnotationUtils.getFirstAnnotation((IAnnotatable)classType, annotationName);
                this.collectProperties(context.getCollector(), info, (IMember)classType, mpftAnnotationForClass, mpftContext);
            }
            this.collectProperties(context.getCollector(), info, (IMember)javaElement, mpftAnnotation, mpftContext);
        }
    }

    private static MicroProfileFaultToleranceContext getMicroProfileFaultToleranceContext(SearchContext context) {
        MicroProfileFaultToleranceContext mpftContext = (MicroProfileFaultToleranceContext)context.get(MICROPROFILE_FAULT_TOLERANCE_CONTEXT_KEY);
        if (mpftContext == null) {
            mpftContext = new MicroProfileFaultToleranceContext(context.getJavaProject(), context.getUtils(), context.getDocumentFormat());
            context.put(MICROPROFILE_FAULT_TOLERANCE_CONTEXT_KEY, mpftContext);
        }
        return mpftContext;
    }

    static class AnnotationInfo {
        private final String name;
        private final String simpleName;
        private final List<AnnotationParameter> parameters;

        public AnnotationInfo(IType annotation, IJDTUtils utils, DocumentFormat documentFormat) throws JavaModelException {
            this.name = annotation.getFullyQualifiedName();
            this.simpleName = annotation.getElementName();
            this.parameters = new ArrayList<AnnotationParameter>();
            IMethod[] methods = annotation.getMethods();
            if (methods != null) {
                IMethod[] iMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    String name = method.getElementName();
                    String methodResultTypeName = JDTTypeUtils.getResolvedResultTypeName(method);
                    IType returnType = JDTTypeUtils.findType(method.getJavaProject(), methodResultTypeName);
                    String type = JDTTypeUtils.getPropertyType(returnType, methodResultTypeName);
                    String description = utils.getJavadoc((IMember)method, documentFormat);
                    String sourceType = JDTTypeUtils.getSourceType((IMember)method);
                    String sourceMethod = JDTTypeUtils.getSourceMethod(method);
                    String defaultValue = JDTTypeUtils.getDefaultValue(method);
                    IType enclosedType = JDTTypeUtils.getEnclosedType(returnType, type, method.getJavaProject());
                    AnnotationParameter parameter = new AnnotationParameter(name, type, enclosedType, description, sourceType, sourceMethod, defaultValue);
                    this.parameters.add(parameter);
                    ++n2;
                }
            }
            AnnotationParameter parameter = new AnnotationParameter("enabled", "boolean", null, "Enabling the policy", this.name, null, "true");
            this.parameters.add(parameter);
        }

        public String getName() {
            return this.name;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public List<AnnotationParameter> getParameters() {
            return this.parameters;
        }
    }

    static class AnnotationParameter {
        private final String name;
        private final String type;
        private final IType jdtType;
        private final String description;
        private final String sourceType;
        private final String sourceMethod;
        private final String defaultValue;

        public AnnotationParameter(String name, String type, IType jdtType, String description, String sourceType, String sourceMethod, String defaultValue) {
            this.name = name;
            this.type = type;
            this.jdtType = jdtType;
            this.description = description;
            this.sourceType = sourceType;
            this.sourceMethod = sourceMethod;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getSourceMethod() {
            return this.sourceMethod;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public IType getJDTType() {
            return this.jdtType;
        }
    }

    static class MicroProfileFaultToleranceContext {
        private final IJavaProject javaProject;
        private final IJDTUtils utils;
        private final DocumentFormat documentFormat;
        private final Map<String, AnnotationInfo> cache = new HashMap<String, AnnotationInfo>();
        private final Set<String> processedAnnotations = new HashSet<String>();

        public MicroProfileFaultToleranceContext(IJavaProject javaProject, IJDTUtils utils, DocumentFormat documentFormat) {
            this.javaProject = javaProject;
            this.utils = utils;
            this.documentFormat = documentFormat;
        }

        public AnnotationInfo getAnnotationInfo(String annotation, IProgressMonitor monitor) throws JavaModelException {
            AnnotationInfo info = this.cache.get(annotation);
            if (info != null) {
                return info;
            }
            return this.registerAnnotation(annotation, monitor);
        }

        private AnnotationInfo registerAnnotation(String annotationName, IProgressMonitor monitor) throws JavaModelException {
            IType annotation = this.javaProject.findType(annotationName);
            if (annotation == null) {
                return null;
            }
            IOrdinaryClassFile classFile = annotation.getClassFile();
            if (classFile != null) {
                try {
                    this.utils.discoverSource((IClassFile)classFile, monitor);
                }
                catch (CoreException e) {
                    LOGGER.log(Level.WARNING, "Error while downloading sources for MicroProfile Fault Tolerance dependency", e);
                }
            }
            AnnotationInfo info = new AnnotationInfo(annotation, this.utils, this.documentFormat);
            this.cache.put(info.getName(), info);
            return info;
        }

        public boolean isProcessed(String annotationName) {
            return this.isProcessed(null, annotationName);
        }

        public boolean isProcessed(String className, String annotationName) {
            return this.processedAnnotations.contains(MicroProfileFaultToleranceProvider.createPrefix(className, null, annotationName));
        }

        public boolean setProcessed(String annotationName) {
            return this.setProcessed(null, annotationName);
        }

        public boolean setProcessed(String className, String annotationName) {
            return this.processedAnnotations.add(MicroProfileFaultToleranceProvider.createPrefix(className, null, annotationName));
        }

        public void addFaultToleranceProperties(IPropertiesCollector collector) {
            if (this.processedAnnotations.contains("MP_Fault_Tolerance_NonFallback_Enabled")) {
                return;
            }
            collector.addItemMetadata("MP_Fault_Tolerance_NonFallback_Enabled", "boolean", "Some service mesh platforms, e.g. Istio, have their own Fault Tolerance policy.\r\nThe operation team might want to use the platform Fault Tolerance.\r\nIn order to fulfil the requirement, MicroProfile Fault Tolerance provides a capability to have its resilient functionalities disabled except `fallback`.\r\nThe reason `fallback` is special is that the `fallback` business logic can only be defined by microservices and not by any other platforms.\r\n\r\nSetting the config property of `MP_Fault_Tolerance_NonFallback_Enabled` with the value of `false` means the Fault Tolerance is disabled, except `@Fallback`.\r\nIf the property is absent or with the value of `true`, it means that MicroProfile Fault Tolerance is enabled if any annotations are specified.  For more information about how to set config properties, refer to MicroProfile Config specification.\r\n\r\nIn order to prevent from any unexpected behaviours, the property `MP_Fault_Tolerance_NonFallback_Enabled` will only be read on application starting.\r\nAny dynamic changes afterwards will be ignored until  the application restarting.", null, null, null, "false", null, false, 0);
            this.processedAnnotations.add("MP_Fault_Tolerance_NonFallback_Enabled");
        }
    }
}

