/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class DiagnosticUtils {
    private static final String LEVEL1_URI_REGEX = "(?:\\/(?:(?:\\{(\\w|-|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+\\})|(?:(\\w|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+)))*\\/?";

    public static boolean isMatchedAnnotation(ICompilationUnit unit, IAnnotation annotation, String annotationFQName) throws JavaModelException {
        String elementName = annotation.getElementName();
        if (DiagnosticUtils.nameEndsWith(annotationFQName, elementName) && unit != null) {
            if (DiagnosticUtils.isImportedJavaElement(unit, annotationFQName)) {
                return true;
            }
            if (annotationFQName.equals(elementName)) {
                String[][] fqName;
                IType declaringType;
                IJavaElement parent = annotation.getParent();
                Object object = parent instanceof IType ? (IType)parent : (declaringType = parent instanceof IMember ? ((IMember)parent).getDeclaringType() : null);
                if (declaringType != null && (fqName = declaringType.resolveType(elementName)) != null && fqName.length == 1) {
                    return annotationFQName.equals(JavaModelUtil.concatenateName((String)fqName[0][0], (String)fqName[0][1]));
                }
            }
        }
        return false;
    }

    public static boolean isMatchedJavaElement(IType type, String javaElementName, String javaElementFQName) throws JavaModelException {
        if (DiagnosticUtils.nameEndsWith(javaElementFQName, javaElementName)) {
            String[][] fqName;
            if (DiagnosticUtils.isImportedJavaElement(type.getCompilationUnit(), javaElementFQName)) {
                return true;
            }
            if ((javaElementFQName.equals(javaElementName) || javaElementFQName.startsWith("java.lang")) && (fqName = type.resolveType(javaElementName)) != null && fqName.length == 1) {
                return javaElementFQName.equals(JavaModelUtil.concatenateName((String)fqName[0][0], (String)fqName[0][1]));
            }
        }
        return false;
    }

    public static boolean isImportedJavaElement(ICompilationUnit unit, String javaElementFQName) throws JavaModelException {
        IImportDeclaration[] importDeclArray;
        IImportContainer container;
        if (!unit.isOpen()) {
            unit.open(null);
        }
        if ((container = unit.getImportContainer()) == null) {
            return false;
        }
        IImportDeclaration[] iImportDeclarationArray = importDeclArray = unit.getImports();
        int n = importDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fqn;
            String qualifier;
            IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
            if (importDeclaration.isOnDemand() ? (qualifier = (fqn = importDeclaration.getElementName()).substring(0, fqn.lastIndexOf(46))).equals(javaElementFQName.substring(0, javaElementFQName.lastIndexOf(46))) : importDeclaration.getElementName().equals(javaElementFQName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isImportedJavaElement(ICompilationUnit unit, String[] javaElementFQNames) throws JavaModelException {
        IImportDeclaration[] importDeclArray;
        IImportContainer container;
        if (!unit.isOpen()) {
            unit.open(null);
        }
        if ((container = unit.getImportContainer()) == null) {
            return false;
        }
        IImportDeclaration[] iImportDeclarationArray = importDeclArray = unit.getImports();
        int n = importDeclArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
            if (importDeclaration.isOnDemand()) {
                String fqn = importDeclaration.getElementName();
                String qualifier = fqn.substring(0, fqn.lastIndexOf(46));
                boolean imports = Stream.of(javaElementFQNames).anyMatch(elementFQName -> qualifier.equals(elementFQName.substring(0, elementFQName.lastIndexOf(46))));
                if (imports) {
                    return true;
                }
            } else {
                String importName = importDeclaration.getElementName();
                if (Stream.of(javaElementFQNames).anyMatch(elementFQName -> importName.equals(elementFQName))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean doesImplementInterfaces(IType type, String[] interfaceFQNames) throws JavaModelException {
        String[] interfaceNames = type.getSuperInterfaceNames();
        if (interfaceNames.length > 0) {
            IType[] interfaces;
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = interfaces = typeHierarchy.getAllInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IType interfase = iTypeArray[n2];
                String fqName = interfase.getFullyQualifiedName();
                if (Stream.of(interfaceFQNames).anyMatch(name -> fqName.equals(name))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String getMatchedJavaElementName(IType type, String javaElementName, String[] javaElementFQNames) throws JavaModelException {
        String[] matches = (String[])Stream.of(javaElementFQNames).filter(fqName -> DiagnosticUtils.nameEndsWith(fqName, javaElementName)).toArray(String[]::new);
        if (matches.length > 0 && DiagnosticUtils.isMatchedJavaElement(type, javaElementName, matches[0])) {
            return matches[0];
        }
        return null;
    }

    public static List<String> getMatchedJavaElementNames(IType type, String[] javaElementNames, String[] javaElementFQNames) {
        return Stream.of(javaElementFQNames).filter(fqName -> {
            boolean anyMatch = Stream.of(javaElementNames).anyMatch(name -> {
                try {
                    return DiagnosticUtils.isMatchedJavaElement(type, name, fqName);
                }
                catch (JavaModelException e) {
                    JakartaCorePlugin.logException("Failed to get matched Java element FQ names", e);
                    return false;
                }
            });
            return anyMatch;
        }).collect(Collectors.toList());
    }

    public static boolean nameEndsWith(String fqName, String name) {
        return fqName.equals(name) || fqName.endsWith("." + name);
    }

    public static String getSimpleName(String fqName) {
        int idx = fqName.lastIndexOf(46);
        if (idx != -1 && idx != fqName.length() - 1) {
            return fqName.substring(idx + 1);
        }
        return fqName;
    }

    public static boolean isConstructorMethod(IMethod m) {
        try {
            return m.isConstructor();
        }
        catch (JavaModelException e) {
            JakartaCorePlugin.logException("Failed to check constructor method", e);
            return false;
        }
    }

    public static List<IMethod> getFieldAccessors(ICompilationUnit unit, IField field) throws JavaModelException {
        ArrayList<IMethod> accessors = new ArrayList<IMethod>();
        String fieldName = field.getElementName();
        fieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
        ArrayList<String> accessorNames = new ArrayList<String>();
        accessorNames.add("get" + fieldName);
        accessorNames.add("set" + fieldName);
        accessorNames.add("is" + fieldName);
        IType[] iTypeArray = unit.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                String methodName = method.getElementName();
                if (accessorNames.contains(methodName)) {
                    accessors.add(method);
                }
                ++n4;
            }
            ++n2;
        }
        return accessors;
    }

    public static boolean hasLeadingSlash(String uri) {
        return uri.startsWith("/");
    }

    public static boolean isValidLevel1URI(String uriString) {
        return uriString.matches(LEVEL1_URI_REGEX);
    }
}

