/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ChangeCorrectionProposal;

public class NewAnnotationProposal
extends ChangeCorrectionProposal {
    private final CompilationUnit fInvocationNode;
    private final IBinding fBinding;
    protected final String[] annotations;

    public NewAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String ... annotations) {
        super(label, "quickfix", targetCU, null, relevance);
        this.fInvocationNode = invocationNode;
        this.fBinding = binding;
        this.annotations = annotations;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode declNode = null;
        ASTNode boundNode = this.fInvocationNode.findDeclaringNode(this.fBinding);
        CompilationUnit newRoot = this.fInvocationNode;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        boolean isField = declNode instanceof VariableDeclarationFragment;
        if (isField) {
            declNode = declNode.getParent();
        }
        if (declNode instanceof TypeDeclaration || declNode instanceof MethodDeclaration || isField) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, imports);
            String[] stringArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                MarkerAnnotation marker = ast.newMarkerAnnotation();
                marker.setTypeName(ast.newName(imports.addImport(annotation, (ImportRewrite.ImportRewriteContext)importRewriteContext)));
                if (isField) {
                    rewrite.getListRewrite(declNode, FieldDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
                } else if (declNode instanceof MethodDeclaration) {
                    rewrite.getListRewrite(declNode, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
                } else if (declNode instanceof TypeDeclaration) {
                    rewrite.getListRewrite(declNode, TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
                }
                ++n2;
            }
            return rewrite;
        }
        return null;
    }

    protected CompilationUnit getInvocationNode() {
        return this.fInvocationNode;
    }

    protected IBinding getBinding() {
        return this.fBinding;
    }

    protected String[] getAnnotations() {
        return this.annotations;
    }
}

