/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.junit.Test;

public class ResourceAnnotationTest
extends BaseJakartaTest {
    protected static JDTUtils JDT_UTILS = new JDTUtils();

    @Test
    public void GeneratedAnnotation() throws Exception {
        IJavaProject javaProject = ResourceAnnotationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/annotations/ResourceAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(22, 0, 22, "The @Resource annotation must define the attribute 'type'.", DiagnosticSeverity.Error, "jakarta-annotations", "MissingResourceTypeAttribute");
        Diagnostic d2 = JakartaForJavaAssert.d(39, 0, 30, "The @Resource annotation must define the attribute 'name'.", DiagnosticSeverity.Error, "jakarta-annotations", "MissingResourceNameAttribute");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, JDT_UTILS, d1, d2);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(22, 0, 22, 22, "@Resource(name = \"aa\", type = \"\")");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Add type to jakarta.annotation.Resource", d1, te);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, JDT_UTILS, ca);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te1 = JakartaForJavaAssert.te(39, 0, 39, 30, "@Resource(type = \"\", name = \"\")");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Add name to jakarta.annotation.Resource", d2, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, JDT_UTILS, ca1);
    }
}

