/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.servlet;

import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class ListenerDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-servlet";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit != null) {
            try {
                IType[] alltypes;
                IType[] iTypeArray = alltypes = unit.getAllTypes();
                int n = alltypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IAnnotation[] allAnnotations = type.getAnnotations();
                    boolean isWebListenerAnnotated = false;
                    IAnnotation[] iAnnotationArray = allAnnotations;
                    int n3 = allAnnotations.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAnnotation annotation = iAnnotationArray[n4];
                        if (ListenerDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.servlet.annotation.WebListener")) {
                            isWebListenerAnnotated = true;
                            break;
                        }
                        ++n4;
                    }
                    String[] interfaces = new String[]{"jakarta.servlet.ServletContextListener", "jakarta.servlet.ServletContextAttributeListener", "jakarta.servlet.ServletRequestListener", "jakarta.servlet.ServletRequestAttributeListener", "jakarta.servlet.http.HttpSessionListener", "jakarta.servlet.http.HttpSessionAttributeListener", "jakarta.servlet.http.HttpSessionIdListener"};
                    boolean isImplemented = ListenerDiagnosticsCollector.doesImplementInterfaces(type, interfaces);
                    if (isWebListenerAnnotated && !isImplemented) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)type, unit, "Annotated classes with @WebListener must implement one or more of the following interfaces: ServletContextListener, ServletContextAttributeListener, ServletRequestListener, ServletRequestAttributeListener, HttpSessionListener, HttpSessionAttributeListener, or HttpSessionIdListener.", "ImplementListener", null, DiagnosticSeverity.Error));
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
            }
        }
    }
}

