/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.di;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4jakarta.jdt.core.AbstractDiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class DependencyInjectionDiagnosticsCollector
extends AbstractDiagnosticsCollector {
    @Override
    protected String getDiagnosticSource() {
        return "jakarta-di";
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        if (unit == null) {
            return;
        }
        try {
            IType[] alltypes;
            IType[] iTypeArray = alltypes = unit.getAllTypes();
            int n = alltypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod[] allMethods;
                IField[] allFields;
                IType type = iTypeArray[n2];
                IField[] iFieldArray = allFields = type.getFields();
                int n3 = allFields.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField field = iFieldArray[n4];
                    if (Flags.isFinal((int)field.getFlags()) && this.containsAnnotation(type, field.getAnnotations(), "jakarta.inject.Inject")) {
                        String msg = this.createAnnotationDiagnostic("Inject", "a final field.");
                        diagnostics.add(this.createDiagnostic((IJavaElement)field, unit, msg, "RemoveInjectOrFinal", field.getElementType(), DiagnosticSeverity.Error));
                    }
                    ++n4;
                }
                ArrayList<IMethod> injectedConstructors = new ArrayList<IMethod>();
                IMethod[] iMethodArray = allMethods = type.getMethods();
                int n5 = allMethods.length;
                int n6 = 0;
                while (n6 < n5) {
                    boolean isGeneric;
                    IMethod method = iMethodArray[n6];
                    int methodFlag = method.getFlags();
                    boolean isFinal = Flags.isFinal((int)methodFlag);
                    boolean isAbstract = Flags.isAbstract((int)methodFlag);
                    boolean isStatic = Flags.isStatic((int)methodFlag);
                    boolean bl = isGeneric = method.getTypeParameters().length != 0;
                    if (this.containsAnnotation(type, method.getAnnotations(), "jakarta.inject.Inject")) {
                        String msg;
                        if (DependencyInjectionDiagnosticsCollector.isConstructorMethod(method)) {
                            injectedConstructors.add(method);
                        }
                        if (isFinal) {
                            msg = this.createAnnotationDiagnostic("Inject", "a final method.");
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, msg, "RemoveInjectOrFinal", method.getElementType(), DiagnosticSeverity.Error));
                        }
                        if (isAbstract) {
                            msg = this.createAnnotationDiagnostic("Inject", "an abstract method.");
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, msg, "RemoveInjectOrAbstract", method.getElementType(), DiagnosticSeverity.Error));
                        }
                        if (isStatic) {
                            msg = this.createAnnotationDiagnostic("Inject", "a static method.");
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, msg, "RemoveInjectOrStatic", method.getElementType(), DiagnosticSeverity.Error));
                        }
                        if (isGeneric) {
                            msg = this.createAnnotationDiagnostic("Inject", "a generic method.");
                            diagnostics.add(this.createDiagnostic((IJavaElement)method, unit, msg, "RemoveInjectForGeneric", method.getElementType(), DiagnosticSeverity.Error));
                        }
                    }
                    ++n6;
                }
                if (injectedConstructors.size() > 1) {
                    String msg = this.createAnnotationDiagnostic("Inject", "more than one constructor.");
                    for (IMethod m : injectedConstructors) {
                        diagnostics.add(this.createDiagnostic((IJavaElement)m, unit, msg, "RemoveInject", null, DiagnosticSeverity.Error));
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JakartaCorePlugin.logException("Cannot calculate diagnostics", e);
        }
    }

    private String createAnnotationDiagnostic(String annotation, String attributeType) {
        return "The annotation @" + annotation + " must not define " + attributeType;
    }

    private boolean containsAnnotation(IType type, IAnnotation[] annotations, String annotationFQName) {
        return Stream.of(annotations).anyMatch(annotation -> {
            try {
                return DependencyInjectionDiagnosticsCollector.isMatchedJavaElement(type, annotation.getElementName(), annotationFQName);
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot validate annotations", e);
                return false;
            }
        });
    }
}

