/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;

public class TypeHierarchyUtils {
    public static int doesITypeHaveSuperType(IType type, String superType) throws CoreException {
        IType[] parents;
        if (type.getElementName().equals(superType)) {
            return 1;
        }
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, null);
        int r = 0;
        IType[] iTypeArray = parents = typeHierarchy.getAllSupertypes(type);
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            IType parentType = iTypeArray[n2];
            if (parentType.getElementName().equals(superType)) {
                r = 1;
                break;
            }
            ++n2;
        }
        if (r == 0) {
            boolean unknown = false;
            IType[] iTypeArray2 = parents;
            int n3 = parents.length;
            n = 0;
            while (n < n3) {
                IType parentType = iTypeArray2[n];
                if (!parentType.getFullyQualifiedName().startsWith("java.") && !TypeHierarchyUtils.hasKnownDeclaration(parentType)) {
                    unknown = true;
                    break;
                }
                ++n;
            }
            if (!unknown) {
                r = -1;
            }
        }
        return r;
    }

    private static boolean hasKnownDeclaration(IType type) throws CoreException {
        final String typeName = type.getElementName();
        final AtomicInteger references = new AtomicInteger(0);
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)5, (int)0, (int)0);
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, TypeHierarchyUtils.createSearchScope(type.getJavaProject()), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType t;
                Object o = match.getElement();
                if (o instanceof IType && (t = (IType)o).getElementName().equals(typeName)) {
                    references.incrementAndGet();
                }
            }
        }, null);
        return references.get() > 0;
    }

    private static IJavaSearchScope createSearchScope(IJavaProject javaProject) throws CoreException {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{javaProject}, (int)1);
    }
}

