/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.jdt.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaForJavaAssert;
import org.junit.Test;

public class PostConstructAnnotationTest
extends BaseJakartaTest {
    protected static JDTUtils JDT_UTILS = new JDTUtils();

    @Test
    public void GeneratedAnnotation() throws Exception {
        IJavaProject javaProject = PostConstructAnnotationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/annotations/PostConstructAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaDiagnosticsParams diagnosticsParams = new JakartaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(15, 19, 31, "A method with the annotation @PostConstruct must be void.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructReturnType");
        Diagnostic d2 = JakartaForJavaAssert.d(20, 16, 28, "A method with the annotation @PostConstruct must not have any parameters.", DiagnosticSeverity.Error, "jakarta-annotations", "PostConstructParams");
        Diagnostic d3 = JakartaForJavaAssert.d(25, 16, 28, "A method with the annotation @PostConstruct must not throw checked exceptions.", DiagnosticSeverity.Warning, "jakarta-annotations", "PostConstructException");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, JDT_UTILS, d1, d2, d3);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te1 = JakartaForJavaAssert.te(19, 4, 20, 4, "");
        TextEdit te2 = JakartaForJavaAssert.te(20, 29, 20, 40, "");
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove @PostConstruct", d2, te1);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove all parameters", d2, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, JDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te3 = JakartaForJavaAssert.te(15, 11, 15, 18, "void");
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Change return type to void", d1, te3);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, JDT_UTILS, ca3);
    }
}

