/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public final class LSPImages {
    private static @Nullable ImageRegistry imageRegistry;
    private static final Map<java.awt.Color, Image> colorToImageCache;
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String OBJECT = "$nl$/icons/full/obj16/";
    private static final String ACTION = "$nl$/icons/full/elcl16/";
    private static final Image EMPTY_IMAGE;
    public static final String IMG_MODULE = "IMG_MODULE";
    public static final String IMG_NAMESPACE = "IMG_NAMESPACE";
    public static final String IMG_PACKAGE = "IMG_PACKAGE";
    public static final String IMG_CLASS = "IMG_CLASS";
    public static final String IMG_TYPE_PARAMETER = "IMG_TYPE_PARAMETER";
    public static final String IMG_METHOD = "IMG_METOHD";
    public static final String IMG_PROPERTY = "IMG_PROPERTY";
    public static final String IMG_FIELD = "IMG_FIELD";
    public static final String IMG_CONSTRUCTOR = "IMG_CONSTRUCTOR";
    public static final String IMG_ENUM = "IMG_ENUM";
    public static final String IMG_ENUM_MEMBER = "IMG_ENUM_MEMBER";
    public static final String IMG_STRUCT = "IMG_STRUCT";
    public static final String IMG_INTERACE = "IMG_INTERFACE";
    public static final String IMG_FUNCTION = "IMG_FUNCTION";
    public static final String IMG_VARIABLE = "IMG_VARIABLE";
    public static final String IMG_CONSTANT = "IMG_CONSTANT";
    public static final String IMG_OBJECT = "IMG_OBJECT";
    public static final String IMG_TEXT = "IMG_TEXT";
    public static final String IMG_NUMBER = "IMG_NUMBER";
    public static final String IMG_BOOLEAN = "IMG_BOOLEAN";
    public static final String IMG_ARRAY = "IMG_ARRAY";
    public static final String IMG_NULL = "IMG_NULL";
    public static final String IMG_UNIT = "IMG_UNIT";
    public static final String IMG_VALUE = "IMG_VALUE";
    public static final String IMG_KEYWORD = "IMG_KEYWORD";
    public static final String IMG_SNIPPET = "IMG_SNIPPET";
    public static final String IMG_REFERENCE = "IMG_REFERENCE";
    public static final String IMG_TERMINATE_CO = "IMG_TERMINATE_CO";
    public static final String IMG_EVENT = "IMG_EVENT";
    public static final String IMG_KEY = "IMG_KEY";
    public static final String IMG_OPERATOR = "IMG_OPERATOR";
    public static final String IMG_SUPERTYPE = "IMG_SUPERTYPE";
    public static final String IMG_SUBTYPE = "IMG_SUBTYPE";

    static {
        colorToImageCache = new HashMap<java.awt.Color, Image>();
        EMPTY_IMAGE = new Image((Device)UI.getDisplay(), 16, 16);
    }

    private LSPImages() {
    }

    public static void initalize(ImageRegistry registry) {
        imageRegistry = registry;
        LSPImages.declareRegistryImage(IMG_MODULE, "$nl$/icons/full/obj16/module.svg");
        LSPImages.declareRegistryImage(IMG_NAMESPACE, "$nl$/icons/full/obj16/namespace.svg");
        LSPImages.declareRegistryImage(IMG_PACKAGE, "$nl$/icons/full/obj16/package.svg");
        LSPImages.declareRegistryImage(IMG_CLASS, "$nl$/icons/full/obj16/class.svg");
        LSPImages.declareRegistryImage(IMG_TYPE_PARAMETER, "$nl$/icons/full/obj16/type_parameter.svg");
        LSPImages.declareRegistryImage(IMG_METHOD, "$nl$/icons/full/obj16/method.svg");
        LSPImages.declareRegistryImage(IMG_PROPERTY, "$nl$/icons/full/obj16/property.svg");
        LSPImages.declareRegistryImage(IMG_FIELD, "$nl$/icons/full/obj16/field.svg");
        LSPImages.declareRegistryImage(IMG_CONSTRUCTOR, "$nl$/icons/full/obj16/constructor.svg");
        LSPImages.declareRegistryImage(IMG_ENUM, "$nl$/icons/full/obj16/enum.svg");
        LSPImages.declareRegistryImage(IMG_ENUM_MEMBER, "$nl$/icons/full/obj16/enum_member.svg");
        LSPImages.declareRegistryImage(IMG_STRUCT, "$nl$/icons/full/obj16/struct.png");
        LSPImages.declareRegistryImage(IMG_INTERACE, "$nl$/icons/full/obj16/interface.svg");
        LSPImages.declareRegistryImage(IMG_FUNCTION, "$nl$/icons/full/obj16/function.svg");
        LSPImages.declareRegistryImage(IMG_VARIABLE, "$nl$/icons/full/obj16/variable.svg");
        LSPImages.declareRegistryImage(IMG_CONSTANT, "$nl$/icons/full/obj16/constant.svg");
        LSPImages.declareRegistryImage(IMG_OBJECT, "$nl$/icons/full/obj16/object.svg");
        LSPImages.declareRegistryImage(IMG_NUMBER, "$nl$/icons/full/obj16/number.svg");
        LSPImages.declareRegistryImage(IMG_BOOLEAN, "$nl$/icons/full/obj16/boolean.svg");
        LSPImages.declareRegistryImage(IMG_ARRAY, "$nl$/icons/full/obj16/array.svg");
        LSPImages.declareRegistryImage(IMG_NULL, "$nl$/icons/full/obj16/null.svg");
        LSPImages.declareRegistryImage(IMG_KEY, "$nl$/icons/full/obj16/key.svg");
        LSPImages.declareRegistryImage(IMG_EVENT, "$nl$/icons/full/obj16/event.svg");
        LSPImages.declareRegistryImage(IMG_OPERATOR, "$nl$/icons/full/obj16/operator.svg");
        LSPImages.declareRegistryImage(IMG_TEXT, "$nl$/icons/full/obj16/text.svg");
        LSPImages.declareRegistryImage(IMG_UNIT, "$nl$/icons/full/obj16/unit.svg");
        LSPImages.declareRegistryImage(IMG_VALUE, "$nl$/icons/full/obj16/value.svg");
        LSPImages.declareRegistryImage(IMG_KEYWORD, "$nl$/icons/full/obj16/keyword.svg");
        LSPImages.declareRegistryImage(IMG_SNIPPET, "$nl$/icons/full/obj16/snippet.svg");
        LSPImages.declareRegistryImage(IMG_REFERENCE, "$nl$/icons/full/obj16/reference.svg");
        LSPImages.declareRegistryImage(IMG_SUPERTYPE, "$nl$/icons/full/elcl16/super_co.svg");
        LSPImages.declareRegistryImage(IMG_SUBTYPE, "$nl$/icons/full/elcl16/sub_co.svg");
        LSPImages.declareRegistryImage(IMG_TERMINATE_CO, "$nl$/icons/full/obj16/terminate_co.svg");
    }

    private static void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.lsp4e");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        LSPImages.getImageRegistry().put(key, desc);
    }

    public static @Nullable Image getImage(String key) {
        return LSPImages.getImageRegistry().get(key);
    }

    public static @Nullable ImageDescriptor getImageDescriptor(String key) {
        return LSPImages.getImageRegistry().getDescriptor(key);
    }

    public static ImageRegistry getImageRegistry() {
        ImageRegistry imageRegistry = LSPImages.imageRegistry;
        if (imageRegistry == null) {
            imageRegistry = LSPImages.imageRegistry = LanguageServerPlugin.getDefault().getImageRegistry();
        }
        return imageRegistry;
    }

    public static @Nullable Image getSharedImage(@Nullable String imageId) {
        if (imageId == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageId);
    }

    public static @Nullable ImageDescriptor getSharedImageDescriptor(@Nullable String imageId) {
        if (imageId == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageId);
    }

    public static @Nullable Image imageFromSymbolKind(@Nullable SymbolKind kind) {
        SymbolKind symbolKind = kind;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Array", "Boolean", "Class", "Constant", "Constructor", "Enum", "EnumMember", "Struct", "Field", "File", "Function", "Interface", "Method", "Module", "Namespace", "Number", "Object", "Package", "Property", "String", "TypeParameter", "Variable", "Null", "Event", "Key", "Operator"}, (SymbolKind)symbolKind, 0)) {
            case 0 -> LSPImages.getImage(IMG_ARRAY);
            case 1 -> LSPImages.getImage(IMG_BOOLEAN);
            case 2 -> LSPImages.getImage(IMG_CLASS);
            case 3 -> LSPImages.getImage(IMG_CONSTANT);
            case 4 -> LSPImages.getImage(IMG_CONSTRUCTOR);
            case 5 -> LSPImages.getImage(IMG_ENUM);
            case 6 -> LSPImages.getImage(IMG_ENUM_MEMBER);
            case 7 -> LSPImages.getImage(IMG_STRUCT);
            case 8 -> LSPImages.getImage(IMG_FIELD);
            case 9 -> LSPImages.getSharedImage("IMG_OBJ_FILE");
            case 10 -> LSPImages.getImage(IMG_FUNCTION);
            case 11 -> LSPImages.getImage(IMG_INTERACE);
            case 12 -> LSPImages.getImage(IMG_METHOD);
            case 13 -> LSPImages.getImage(IMG_MODULE);
            case 14 -> LSPImages.getImage(IMG_NAMESPACE);
            case 15 -> LSPImages.getImage(IMG_NUMBER);
            case 16 -> LSPImages.getImage(IMG_OBJECT);
            case 17 -> LSPImages.getImage(IMG_PACKAGE);
            case 18 -> LSPImages.getImage(IMG_PROPERTY);
            case 19 -> LSPImages.getImage(IMG_TEXT);
            case 20 -> LSPImages.getImage(IMG_TYPE_PARAMETER);
            case 21 -> LSPImages.getImage(IMG_VARIABLE);
            case 22 -> LSPImages.getImage(IMG_NULL);
            case 23 -> LSPImages.getImage(IMG_EVENT);
            case 24 -> LSPImages.getImage(IMG_KEY);
            case 25 -> LSPImages.getImage(IMG_OPERATOR);
            case -1 -> EMPTY_IMAGE;
            default -> throw new MatchException(null, null);
        };
    }

    public static @Nullable Image imageFromCompletionItem(CompletionItem completionItem) {
        CompletionItemKind completionItemKind = completionItem.getKind();
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Text", "Method", "Function", "Constructor", "Field", "Variable", "Class", "Interface", "Module", "Property", "Unit", "Value", "Enum", "EnumMember", "Struct", "Keyword", "Snippet", "Color", "File", "Folder", "Reference", "Constant", "TypeParameter", "Event", "Operator"}, (CompletionItemKind)completionItemKind, 0)) {
            case 0 -> LSPImages.getImage(IMG_TEXT);
            case 1 -> LSPImages.getImage(IMG_METHOD);
            case 2 -> LSPImages.getImage(IMG_FUNCTION);
            case 3 -> LSPImages.getImage(IMG_CONSTRUCTOR);
            case 4 -> LSPImages.getImage(IMG_FIELD);
            case 5 -> LSPImages.getImage(IMG_VARIABLE);
            case 6 -> LSPImages.getImage(IMG_CLASS);
            case 7 -> LSPImages.getImage(IMG_INTERACE);
            case 8 -> LSPImages.getImage(IMG_MODULE);
            case 9 -> LSPImages.getImage(IMG_PROPERTY);
            case 10 -> LSPImages.getImage(IMG_UNIT);
            case 11 -> LSPImages.getImage(IMG_VALUE);
            case 12 -> LSPImages.getImage(IMG_ENUM);
            case 13 -> LSPImages.getImage(IMG_ENUM_MEMBER);
            case 14 -> LSPImages.getImage(IMG_STRUCT);
            case 15 -> LSPImages.getImage(IMG_KEYWORD);
            case 16 -> LSPImages.getImage(IMG_SNIPPET);
            case 17 -> LSPImages.getImageForColor(completionItem);
            case 18 -> LSPImages.getSharedImage("IMG_OBJ_FILE");
            case 19 -> LSPImages.getSharedImage("IMG_OBJ_FOLDER");
            case 20 -> LSPImages.getImage(IMG_REFERENCE);
            case 21 -> LSPImages.getImage(IMG_CONSTANT);
            case 22 -> LSPImages.getImage(IMG_TYPE_PARAMETER);
            case 23 -> LSPImages.getImage(IMG_EVENT);
            case 24 -> LSPImages.getImage(IMG_OPERATOR);
            case -1 -> null;
            default -> throw new MatchException(null, null);
        };
    }

    private static @Nullable Image getImageForColor(CompletionItem completionItem) {
        String hexValue = null;
        String docString = LSPEclipseUtils.getDocString((Either<String, MarkupContent>)completionItem.getDocumentation());
        if (docString != null && docString.startsWith("#")) {
            hexValue = docString;
        } else if (completionItem.getLabel().startsWith("#")) {
            hexValue = completionItem.getLabel();
        }
        if (hexValue == null) {
            return null;
        }
        java.awt.Color decodedColor = null;
        try {
            decodedColor = java.awt.Color.decode(hexValue);
        }
        catch (NumberFormatException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        return colorToImageCache.computeIfAbsent(decodedColor, key -> {
            Image image = new Image((Device)Display.getDefault(), 16, 16);
            GC gc = new GC((Drawable)image);
            Color color = new Color((Device)Display.getDefault(), key.getRed(), key.getGreen(), key.getBlue(), key.getAlpha());
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 16, 16);
            gc.dispose();
            return image;
        });
    }
}

