/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DocumentDidCloseTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void testClose() throws Exception {
        IProject project = TestUtils.createProject("DocumentDidCloseTest" + System.currentTimeMillis());
        IFile testFile = TestUtils.createUniqueTestFile(project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assert.assertNotNull((Object)document);
        LanguageServiceAccessor.getLanguageServers((IDocument)document, capabilites -> Boolean.TRUE);
        CompletableFuture didCloseExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidCloseCallback(didCloseExpectation);
        TestUtils.closeEditor(editor, false);
        DidCloseTextDocumentParams lastChange = (DidCloseTextDocumentParams)didCloseExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getTextDocument());
        Assert.assertEquals((Object)LSPEclipseUtils.toUri((IResource)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
    }

    @Test
    public void testCloseExternalFile() throws Exception {
        File testFile = TestUtils.createTempFile("testCloseExternalFile", ".lspt");
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)testFile.toURI()));
        LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput()), capabilites -> Boolean.TRUE);
        CompletableFuture didCloseExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidCloseCallback(didCloseExpectation);
        TestUtils.closeEditor(editor, false);
        DidCloseTextDocumentParams lastChange = (DidCloseTextDocumentParams)didCloseExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getTextDocument());
        Assert.assertEquals((Object)LSPEclipseUtils.toUri((File)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
    }
}

