/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.enablement;

import java.util.function.Supplier;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LanguageServerPlugin;

public final class EnablementTester {
    private final Expression expression;
    private final String description;
    private final Supplier<IEvaluationContext> parent;

    public EnablementTester(Expression expression, String description) {
        this(() -> null, expression, description);
    }

    public EnablementTester(Supplier<IEvaluationContext> parent, Expression expression, String description) {
        this.description = description;
        this.expression = expression;
        this.parent = parent;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean evaluate() {
        try {
            EvaluationContext context = new EvaluationContext(this.parent.get(), new Object());
            context.setAllowPluginActivation(true);
            return this.expression.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError("Error occured during evaluation of enablement expression", e);
            return false;
        }
    }
}

