/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.references;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.operations.references.LSFindReferences;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FindReferencesTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("CompletionTest" + System.currentTimeMillis());
        ISearchResultViewPart searchPart = NewSearchUI.getSearchResultView();
        if (searchPart != null) {
            searchPart.getViewSite().getPage().hideView((IViewPart)searchPart);
        }
    }

    @After
    public void tearDown() throws CoreException {
        ISearchResultViewPart searchPart = NewSearchUI.getSearchResultView();
        if (searchPart != null) {
            searchPart.getViewSite().getPage().hideView((IViewPart)searchPart);
        }
    }

    @Test
    public void findReferencesShowsResultView() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "dummyContent");
        TestUtils.openTextViewer(testFile);
        MockLanguageServer.INSTANCE.getTextDocumentService().setMockReferences(new Location(testFile.getLocationURI().toString(), new Range(new Position(1, 1), new Position(1, 2))));
        LSFindReferences handler = new LSFindReferences();
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        handler.execute(new ExecutionEvent(null, new HashMap(), null, (Object)evaluationService.getCurrentState()));
        ISearchResultViewPart part = this.findSearchResultView(3000);
        Assert.assertNotNull((String)"Search results not shown", (Object)part);
    }

    private ISearchResultViewPart findSearchResultView(int timeout) {
        new DisplayHelper(){

            protected boolean condition() {
                return NewSearchUI.getSearchResultView() != null;
            }
        }.waitForCondition(Display.getCurrent(), (long)timeout);
        return NewSearchUI.getSearchResultView();
    }

    @Test
    public void findReferencesNonBlocking() throws Exception {
        int responseDelay = 3000;
        int uiFreezeThreesholdreezeThreeshold = 300;
        MockLanguageServer.INSTANCE.setTimeToProceedQueries((long)responseDelay);
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "dummyContent"));
        LSFindReferences handler = new LSFindReferences();
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        long time = System.currentTimeMillis();
        handler.execute(new ExecutionEvent(null, new HashMap(), null, (Object)evaluationService.getCurrentState()));
        long delay = System.currentTimeMillis() - time;
        Assert.assertTrue((String)("Find references blocked UI for " + delay + "ms"), (delay < (long)uiFreezeThreesholdreezeThreeshold ? 1 : 0) != 0);
        AtomicInteger runCount = new AtomicInteger();
        Thread uiThreadActiveChecker = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                long triggerTime = System.currentTimeMillis();
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                    runCount.incrementAndGet();
                    long uiThreadRequestTime = System.currentTimeMillis() - triggerTime;
                    Assert.assertTrue((String)("UI Thread blocked for " + uiThreadRequestTime), (uiThreadRequestTime < (long)uiFreezeThreesholdreezeThreeshold ? 1 : 0) != 0);
                });
            }
        });
        uiThreadActiveChecker.start();
        try {
            Assert.assertNotNull((String)"Search Result view not found", (Object)this.findSearchResultView(5000));
            Assert.assertTrue((String)"UI Thread was frozen", (runCount.intValue() > 1000 ? 1 : 0) != 0);
        }
        finally {
            uiThreadActiveChecker.interrupt();
        }
    }
}

