/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentDidChangeTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DocumentDidChangeTest" + System.currentTimeMillis());
    }

    @Test
    public void testIncrementalSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                TextDocumentSyncKind syncKind = DocumentDidChangeTest.this.getDocumentSyncKind(t);
                Assert.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)syncKind);
                return true;
            }
        });
        CompletableFuture didChangeExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
        viewer.getDocument().replace(0, 0, "Hello");
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)0L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)0, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"Hello", (Object)change0.getText());
        didChangeExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
        viewer.getDocument().replace(5, 0, " ");
        lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)5L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)0, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)" ", (Object)change0.getText());
        didChangeExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
        viewer.getDocument().replace(0, 5, "Hallo");
        lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)0L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)0L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)5, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"Hallo", (Object)change0.getText());
    }

    @Test
    public void testIncrementalSync_deleteLastLine() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        String multiLineText = "line1\nline2\nline3\n";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, multiLineText);
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        CompletableFuture didChangeExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
        viewer.getDocument().replace("line1\nline2\n".length(), "line3\n".length(), "");
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((long)2L, (long)range.getStart().getLine());
        Assert.assertEquals((long)0L, (long)range.getStart().getCharacter());
        Assert.assertEquals((long)3L, (long)range.getEnd().getLine());
        Assert.assertEquals((long)0L, (long)range.getEnd().getCharacter());
        Assert.assertEquals((Object)6, (Object)change0.getRangeLength());
        Assert.assertEquals((Object)"", (Object)change0.getText());
    }

    @Test
    public void testFullSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assert.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        });
        CompletableFuture didChangeExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
        String text = "Hello";
        viewer.getDocument().replace(0, 0, text);
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)text, (Object)change0.getText());
        didChangeExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
        viewer.getDocument().replace(5, 0, " World");
        lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)lastChange.getContentChanges());
        Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assert.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    @Test
    public void testFullSyncExternalFile() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        File file = File.createTempFile("testFullSyncExternalFile", ".lspt");
        try {
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
            ITextViewer viewer = TestUtils.getTextViewer(editor);
            LanguageServiceAccessor.getLanguageServers((IDocument)viewer.getDocument(), (Predicate)new Predicate<ServerCapabilities>(){

                @Override
                public boolean test(ServerCapabilities t) {
                    Assert.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                    return true;
                }
            });
            CompletableFuture didChangeExpectation = new CompletableFuture();
            MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
            String text = "Hello";
            viewer.getDocument().replace(0, 0, text);
            DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)lastChange.getContentChanges());
            Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
            TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
            Assert.assertEquals((Object)text, (Object)change0.getText());
            didChangeExpectation = new CompletableFuture();
            MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
            viewer.getDocument().replace(5, 0, " World");
            lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)lastChange.getContentChanges());
            Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
            change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
            Assert.assertEquals((Object)"Hello World", (Object)change0.getText());
        }
        finally {
            Files.deleteIfExists(file.toPath());
        }
    }

    private TextDocumentSyncKind getDocumentSyncKind(ServerCapabilities t) {
        TextDocumentSyncKind syncKind = null;
        if (t.getTextDocumentSync().isLeft()) {
            syncKind = (TextDocumentSyncKind)t.getTextDocumentSync().getLeft();
        } else if (t.getTextDocumentSync().isRight()) {
            syncKind = ((TextDocumentSyncOptions)t.getTextDocumentSync().getRight()).getChange();
        }
        return syncKind;
    }
}

