/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class NoErrorLoggedRule
extends TestWatcher {
    private ILog log;
    private ILogListener listener;
    private List<IStatus> loggedErrors;

    public NoErrorLoggedRule(ILog log) {
        this.log = log;
        this.listener = (status, message) -> {
            if (status.getSeverity() == 4) {
                this.loggedErrors.add(status);
            }
        };
    }

    protected void starting(Description description) {
        super.starting(description);
        this.loggedErrors = new ArrayList<IStatus>();
        this.log.addLogListener(this.listener);
    }

    protected void finished(Description description) {
        this.log.removeLogListener(this.listener);
        Assert.assertEquals((String)"Some errors were logged", Collections.emptyList(), this.loggedErrors);
        super.finished(description);
    }
}

