/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockLanguageServerMultiRootFolders;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class MockConnectionProviderMultiRootFolders
implements StreamConnectionProvider {
    private InputStream clientInputStream;
    private OutputStream clientOutputStream;
    private InputStream errorStream;
    private Future<Void> listener;
    private Collection<Closeable> streams = new ArrayList<Closeable>(4);

    public void start() throws IOException {
        Pipe serverOutputToClientInput = Pipe.open();
        Pipe clientOutputToServerInput = Pipe.open();
        this.errorStream = new ByteArrayInputStream("Error output on console".getBytes(StandardCharsets.UTF_8));
        InputStream serverInputStream = Channels.newInputStream(clientOutputToServerInput.source());
        OutputStream serverOutputStream = Channels.newOutputStream(serverOutputToClientInput.sink());
        Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)MockLanguageServerMultiRootFolders.INSTANCE, (InputStream)serverInputStream, (OutputStream)serverOutputStream);
        this.clientInputStream = Channels.newInputStream(serverOutputToClientInput.source());
        this.clientOutputStream = Channels.newOutputStream(clientOutputToServerInput.sink());
        this.listener = launcher.startListening();
        MockLanguageServer.INSTANCE.addRemoteProxy((LanguageClient)launcher.getRemoteProxy());
        this.streams.add(this.clientInputStream);
        this.streams.add(this.clientOutputStream);
        this.streams.add(serverInputStream);
        this.streams.add(serverOutputStream);
        this.streams.add(this.errorStream);
    }

    public InputStream getInputStream() {
        return this.clientInputStream;
    }

    public OutputStream getOutputStream() {
        return this.clientOutputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public void stop() {
    }
}

