/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.LSDisplayHelper;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentDidSaveTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
    }

    @Test
    public void testSave() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        ITextViewer viewer = TestUtils.getTextViewer(editor);
        testFile.setLocalTimeStamp(0L);
        LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IResource)testFile), capabilites -> Boolean.TRUE);
        CompletableFuture didSaveExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidSaveCallback(didSaveExpectation);
        viewer.getDocument().replace(0, 0, "Hello");
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        new LSDisplayHelper(() -> {
            try {
                DidSaveTextDocumentParams lastChange = (DidSaveTextDocumentParams)didSaveExpectation.get(10L, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)lastChange.getTextDocument());
                Assert.assertEquals((Object)LSPEclipseUtils.toUri((IResource)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
                return true;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return false;
            }
        }).waitForCondition(Display.getCurrent(), 2000L);
    }

    @Test
    public void testSaveExternalFile() throws Exception {
        File file = File.createTempFile("testSaveExternalFile", ".lspt");
        try {
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
            ITextViewer viewer = TestUtils.getTextViewer(editor);
            LanguageServiceAccessor.getLanguageServers((IDocument)LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput()), capabilites -> Boolean.TRUE);
            CompletableFuture didSaveExpectation = new CompletableFuture();
            MockLanguageServer.INSTANCE.setDidSaveCallback(didSaveExpectation);
            viewer.getDocument().replace(0, 0, "Hello");
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            new LSDisplayHelper(() -> {
                try {
                    DidSaveTextDocumentParams lastChange = (DidSaveTextDocumentParams)didSaveExpectation.get(10L, TimeUnit.MILLISECONDS);
                    Assert.assertNotNull((Object)lastChange.getTextDocument());
                    Assert.assertEquals((Object)LSPEclipseUtils.toUri((File)file).toString(), (Object)lastChange.getTextDocument().getUri());
                    return true;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    return false;
                }
            }).waitForCondition(Display.getCurrent(), 2000L);
        }
        finally {
            Files.deleteIfExists(file.toPath());
        }
    }
}

