/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.lsat.motioncalculator.json.JsonRequest;
import org.eclipse.lsat.motioncalculator.json.JsonResponse;

public class JsonSerializer {
    private static final Gson GSON;
    private static final int SCALE = 16;
    private static final TypeAdapter<BigDecimal> BIGDECIMAL_ADAPTER;

    static {
        BIGDECIMAL_ADAPTER = new TypeAdapter<BigDecimal>(){

            public void write(JsonWriter out, BigDecimal value) throws IOException {
                out.value((Number)JsonSerializer.scale(value));
            }

            public BigDecimal read(JsonReader in) throws IOException {
                return JsonSerializer.scale(new BigDecimal(in.nextString()));
            }
        };
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(BigDecimal.class, BIGDECIMAL_ADAPTER);
        GSON = builder.setPrettyPrinting().create();
    }

    private JsonSerializer() {
    }

    public static String toJson(JsonRequest o) {
        return GSON.toJson((Object)o);
    }

    public static String toJson(JsonResponse o) {
        return GSON.toJson((Object)o);
    }

    public static JsonRequest createRequest(String json) {
        return (JsonRequest)GSON.fromJson(json, JsonRequest.class);
    }

    public static JsonResponse createResponse(String json) {
        return (JsonResponse)GSON.fromJson(json, JsonResponse.class);
    }

    private static BigDecimal scale(BigDecimal value) {
        if (value != null && value.scale() > 16) {
            value = value.setScale(16, RoundingMode.HALF_UP);
            int s = 15;
            while (s >= 1) {
                BigDecimal newValue = value.setScale(s, RoundingMode.HALF_UP);
                if (newValue.doubleValue() != value.doubleValue()) {
                    return value;
                }
                value = newValue;
                --s;
            }
        }
        return value;
    }
}

