/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsat.motioncalculator.TimePosition;

public final class PositionInfo
implements Serializable {
    private static final long serialVersionUID = 3416965088695127653L;
    private String setPointId;
    private List<double[]> timePositions = new ArrayList<double[]>();

    public PositionInfo(String setPointId) {
        this.setPointId = setPointId;
    }

    public String getSetPointId() {
        return this.setPointId;
    }

    public int getDataSize() {
        if (this.timePositions.size() == 0) {
            return 0;
        }
        return this.timePositions.get(0).length;
    }

    public void addTimePosition(double time, double position) {
        this.addData(new double[]{time, position});
    }

    public void addData(double[] data) {
        this.timePositions.add(data);
    }

    public Collection<TimePosition> getTimePositions() {
        int paramIndex = 1;
        return this.getData(paramIndex);
    }

    public Collection<TimePosition> getData(final int paramIndex) {
        return Collections.unmodifiableCollection(new AbstractList<TimePosition>(){

            @Override
            public TimePosition get(int timeIndex) {
                double[] d = PositionInfo.this.timePositions.get(timeIndex);
                return new TimePosition(d[0], paramIndex < d.length ? d[paramIndex] : 0.0);
            }

            @Override
            public int size() {
                return PositionInfo.this.timePositions.size();
            }
        });
    }

    public List<double[]> getAllData() {
        return this.timePositions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.setPointId == null ? 0 : this.setPointId.hashCode());
        result = 31 * result + (this.timePositions == null ? 0 : this.timePositions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PositionInfo other = (PositionInfo)obj;
        if (this.setPointId == null ? other.setPointId != null : !this.setPointId.equals(other.setPointId)) {
            return false;
        }
        return !(this.timePositions == null ? other.timePositions != null : !this.timePositions.equals(other.timePositions));
    }

    public String toString() {
        return "PositionInfo [setPointId=" + this.setPointId + ", timePositions=" + String.valueOf(this.timePositions) + "]";
    }
}

