/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsat.common.mpt.FSM;
import org.eclipse.lsat.common.mpt.Graph;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;

public final class SpecificationTraverser {
    private SpecificationTraverser() {
    }

    public static List<FSM> findAllFSMs(MaxPlusSpecification specification) {
        ArrayList<FSM> fsmList = new ArrayList<FSM>();
        for (Graph g : specification.getGraphs()) {
            if (!(g instanceof FSM)) continue;
            fsmList.add((FSM)g);
        }
        return fsmList;
    }

    public static Optional<FSM> findFSM(MaxPlusSpecification specification) {
        for (Graph g : specification.getGraphs()) {
            if (!(g instanceof FSM)) continue;
            FSM result = (FSM)g;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static Optional<FSM> findFSM(MaxPlusSpecification specification, String fsmName) {
        for (Graph g : specification.getGraphs()) {
            if (!g.getName().equals(fsmName) || !(g instanceof FSM)) continue;
            FSM result = (FSM)g;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

