/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;
import org.eclipse.lsat.common.util.ProcessingIterator;

public class SegmentIterator<E>
extends ProcessingIterator<List<E>> {
    private final Iterator<? extends E> source;
    private final BiPredicate<? super E, ? super E> predicate;
    private LinkedList<E> group;

    public SegmentIterator(Iterator<? extends E> source, BiPredicate<? super E, ? super E> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected boolean toNext() {
        while (this.source.hasNext()) {
            E element = this.source.next();
            if (this.group == null) {
                this.group = new LinkedList();
                this.group.add(element);
                continue;
            }
            if (this.predicate.test(this.group.getLast(), element)) {
                this.group.add(element);
                continue;
            }
            LinkedList<E> next = this.group;
            this.group = new LinkedList();
            this.group.add(element);
            return this.setNext(next);
        }
        if (this.group != null) {
            LinkedList<E> next = this.group;
            this.group = null;
            return this.setNext(next);
        }
        return this.done();
    }
}

