/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.ContainerFileSystemProvider;
import org.eclipse.linuxtools.internal.docker.ui.PopulateContainerFilesOperation;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerCopyToPage;

public class ContainerCopyTo
extends Wizard {
    private DockerConnection connection;
    private IDockerContainer container;
    private String target;
    private List<Object> sources;
    private ContainerCopyToPage mainPage;

    public ContainerCopyTo(IDockerConnection connection, IDockerContainer container) {
        this.connection = (DockerConnection)connection;
        this.container = container;
    }

    public String getTarget() {
        return this.target;
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public void addPages() {
        IDockerContainerInfo info;
        ProgressMonitorDialog pd = new ProgressMonitorDialog(Activator.getActiveWorkbenchShell());
        ContainerFileSystemProvider provider = new ContainerFileSystemProvider((IDockerConnection)this.connection, this.container.id());
        PopulateContainerFilesOperation sfo = new PopulateContainerFilesOperation(new ContainerFileProxy("", "", true), null, provider);
        try {
            pd.run(true, true, (IRunnableWithProgress)sfo);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        boolean isRunning = EnumDockerStatus.fromStatusMessage((String)this.container.status()) == EnumDockerStatus.RUNNING;
        boolean usingTTY = false;
        if (isRunning && (info = this.connection.getContainerInfo(this.container.id())) != null) {
            usingTTY = info.config().tty();
        }
        this.mainPage = new ContainerCopyToPage(sfo.getResult(), provider, this.container.name(), isRunning && usingTTY);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.mainPage.isPageComplete();
    }

    public boolean performFinish() {
        boolean finished = this.mainPage.finish();
        if (finished) {
            this.target = this.mainPage.getDestination().toOSString();
            this.sources = this.mainPage.getFilesToCopy();
        }
        return finished;
    }
}

