/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.participants;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.filepath.participants.AbstractFilePathCompletionTest;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class FilePathCompletionWithDOCTYPETest
extends AbstractFilePathCompletionTest {
    @Test
    public void empty() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 22, 22, "folderA", "folderB", "folderC", "NestedA", "main.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void dotSlash() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"./|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 24, 24, "folderA", "folderB", "folderC", "NestedA", "main.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void dotSlashFollowingBySlash() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"./|/\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 24, 25, "folderA", "folderB", "folderC", "NestedA", "main.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void backSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<!DOCTYPE foo SYSTEM \".\\|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 24, 24, "folderA", "folderB", "folderC", "NestedA", "main.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 5, items);
    }

    @Test
    public void afterFolderA() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"./folderA/|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 32, 32, "dtdA1.dtd", "dtdA2.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void afterFolderABackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<!DOCTYPE foo SYSTEM \".\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 32, 32, "dtdA1.dtd", "dtdA2.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void afterFolderB() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"./folderB/|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 32, 32, "dtdB1.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void afterFolderBBackSlash() throws BadLocationException {
        if (!Platform.isWindows) {
            return;
        }
        String xml = "<!DOCTYPE foo SYSTEM \"./folderB\\|\">";
        CompletionItem[] items = FilePathCompletionWithDOCTYPETest.getCompletionItemList(0, 32, 32, "dtdB1.dtd");
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathNoCompletionMissingSystemId() throws BadLocationException {
        String xml = "<!DOCTYPE foo \"./|\">";
        FilePathCompletionWithDOCTYPETest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }
}

