/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.XMLSymbolExpressionFilter;
import org.eclipse.lemminx.settings.XMLSymbolFilter;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.jupiter.api.Test;

public class XMLSymbolInformationsTest {
    private static final String testURI = "test:URI";

    @Test
    public void testSingleSymbol() {
        String xml = "<project></project>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("project", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 19)), ""));
    }

    @Test
    public void testNestedSymbol() {
        String xml = "<project><inside></inside></project>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("project", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 36)), ""), XMLAssert.si("inside", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 9, 0, 26)), "project"));
    }

    @Test
    public void testTwoNestedSymbols() {
        String xml = "<a><b></b><c></c></a>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 21)), ""), XMLAssert.si("b", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 3, 0, 10)), "a"), XMLAssert.si("c", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 10, 0, 17)), "a"));
    }

    @Test
    public void testNestedTwice() {
        String xml = "<a><b><c></c></b></a>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 21)), ""), XMLAssert.si("b", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 3, 0, 17)), "a"), XMLAssert.si("c", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 6, 0, 13)), "b"));
    }

    @Test
    public void testSelfClosingTag() {
        String xml = "<a/>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 4)), ""));
    }

    @Test
    public void testNestedSelfClosingTag() {
        String xml = "<a><b/></a>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 11)), ""), XMLAssert.si("b", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 3, 0, 7)), "a"));
    }

    @Test
    public void testUnclosedTag() {
        String xml = "<a>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 3)), ""));
    }

    @Test
    public void testNestedUnclosedTag() {
        String xml = "<a><b></a>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 10)), ""), XMLAssert.si("b", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 3, 0, 6)), "a"));
    }

    @Test
    public void testAllTagsUnclosed() {
        String xml = "<a><b>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 6)), ""), XMLAssert.si("b", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 3, 0, 6)), "a"));
    }

    @Test
    public void singleEndTag() throws BadLocationException {
        String xml = "</meta>";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("meta", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 7)), ""));
    }

    @Test
    public void invalidEndTag() {
        String xml = "</";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("?", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 2)), ""));
    }

    @Test
    public void invalidEndTagAfterRoot() {
        String xml = "<a></";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("a", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 5)), ""), XMLAssert.si("?", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 3, 0, 5)), "a"));
    }

    @Test
    public void externalDTD() {
        String xml = "<!ELEMENT br EMPTY>\n<!ATTLIST br\n\t%all;>";
        String testURI = "test.dtd";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("br", SymbolKind.Property, XMLAssert.l(testURI, XMLAssert.r(0, 0, 0, 19)), ""), XMLAssert.si("%all;", SymbolKind.Key, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 6)), ""));
    }

    @Test
    public void internalDTD() {
        String xml = "<!DOCTYPE br [\n  \t<!ELEMENT br EMPTY>\n\t<!ATTLIST br\n\t\t%all;>\n]>\n<br />";
        String testURI = "test.xml";
        XMLAssert.testSymbolInformationsFor(xml, testURI, XMLAssert.si("DOCTYPE:br", SymbolKind.Struct, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 2)), ""), XMLAssert.si("br", SymbolKind.Property, XMLAssert.l(testURI, XMLAssert.r(1, 3, 1, 22)), "DOCTYPE:br"), XMLAssert.si("%all;", SymbolKind.Key, XMLAssert.l(testURI, XMLAssert.r(3, 2, 3, 7)), "DOCTYPE:br"), XMLAssert.si("br", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(5, 0, 5, 6)), ""));
    }

    @Test
    public void exceedSymbolLimit() {
        String xml = "<!DOCTYPE br [\n  \t<!ELEMENT br EMPTY>\n\t<!ATTLIST br\n\t\t%all;>\n]>\n<br />";
        String testURI = "test.xml";
        XMLSymbolSettings settings = new XMLSymbolSettings();
        settings.setMaxItemsComputed(4);
        XMLAssert.testSymbolInformationsFor(xml, testURI, settings, XMLAssert.si("DOCTYPE:br", SymbolKind.Struct, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 2)), ""), XMLAssert.si("br", SymbolKind.Property, XMLAssert.l(testURI, XMLAssert.r(1, 3, 1, 22)), "DOCTYPE:br"), XMLAssert.si("%all;", SymbolKind.Key, XMLAssert.l(testURI, XMLAssert.r(3, 2, 3, 7)), "DOCTYPE:br"), XMLAssert.si("br", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(5, 0, 5, 6)), ""));
        settings.setMaxItemsComputed(10);
        XMLAssert.testSymbolInformationsFor(xml, testURI, settings, XMLAssert.si("DOCTYPE:br", SymbolKind.Struct, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 2)), ""), XMLAssert.si("br", SymbolKind.Property, XMLAssert.l(testURI, XMLAssert.r(1, 3, 1, 22)), "DOCTYPE:br"), XMLAssert.si("%all;", SymbolKind.Key, XMLAssert.l(testURI, XMLAssert.r(3, 2, 3, 7)), "DOCTYPE:br"), XMLAssert.si("br", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(5, 0, 5, 6)), ""));
        settings.setMaxItemsComputed(3);
        XMLAssert.testSymbolInformationsFor(xml, testURI, settings, XMLAssert.si("DOCTYPE:br", SymbolKind.Struct, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 2)), ""), XMLAssert.si("br", SymbolKind.Property, XMLAssert.l(testURI, XMLAssert.r(1, 3, 1, 22)), "DOCTYPE:br"), XMLAssert.si("%all;", SymbolKind.Key, XMLAssert.l(testURI, XMLAssert.r(3, 2, 3, 7)), "DOCTYPE:br"));
    }

    @Test
    public void zeroSymbolLimit() {
        String xml = "<root>\n  <content />\n</root>";
        String testURI = "test.xml";
        XMLSymbolSettings settings = new XMLSymbolSettings();
        settings.setMaxItemsComputed(0);
        XMLAssert.testSymbolInformationsFor(xml, testURI, settings, new SymbolInformation[0]);
    }

    @Test
    public void noSymbolsFilter() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 2, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"));
        symbolSettings = new XMLSymbolSettings();
        symbolSettings.setFilters(new XMLSymbolFilter[0]);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 2, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"));
    }

    @Test
    public void symbolsFilterWithAllAttr() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//@*");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("@attr1: baz-value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(2, 6, 2, 24)), "baz"), XMLAssert.si("@attr2: baz-value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(2, 25, 2, 43)), "baz"));
        expressionFilter.setXpath("//bar/@*");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@*");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
    }

    @Test
    public void symbolsFilterWithOneAttr() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//@attr2");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("@attr2: baz-value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(2, 25, 2, 43)), "baz"));
        expressionFilter.setXpath("//bar/@attr2");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr2");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
    }

    @Test
    public void symbolsFilterWithText() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//text()");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: ABCD", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz: EFGH", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("//bar/text()");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: ABCD", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/text()");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: ABCD", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
    }

    @Test
    public void symbolsFilterExcludeElement() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//baz");
        expressionFilter.setExcluded(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"));
    }

    @Test
    public void symbolsFilterWithNonInlineAttributeShowAttributeName() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("@attr2: baz-value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(2, 25, 2, 43)), "baz"));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr2: value2", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 21, 1, 35)), "bar"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
    }

    @Test
    public void symbolsFilterWithInlineAttributeNoNestedAttributes() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: @attr2: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz: @attr2: baz-value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz: baz-value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: @attr2: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: @attr2: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
    }

    @Test
    public void symbolsFilterWithInlineAttributeWithNestedAttributes() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        XMLSymbolExpressionFilter expressionFilter2 = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter, expressionFilter2});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        expressionFilter2.setXpath("//@attr1");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: @attr2: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar: @attr2: value2"), XMLAssert.si("baz: @attr2: baz-value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("@attr1: baz-value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(2, 6, 2, 24)), "baz: @attr2: baz-value2"));
        expressionFilter.setXpath("//@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("//@attr1");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar: value2"), XMLAssert.si("baz: baz-value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("@attr1: baz-value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(2, 6, 2, 24)), "baz: baz-value2"));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        expressionFilter2.setXpath("//bar/@attr1");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: @attr2: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar: @attr2: value2"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(true);
        expressionFilter2.setXpath("/foo/bar/@attr1");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: @attr2: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar: @attr2: value2"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("//bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("/foo/bar/@attr1");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar: value2"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr2");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("/foo/bar/@attr1");
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 3, 6)), ""), XMLAssert.si("bar: value2", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("@attr1: value1", SymbolKind.Constant, XMLAssert.l(testURI, XMLAssert.r(1, 6, 1, 20)), "bar: value2"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"));
    }

    @Test
    public void symbolsFilterWithInlineAttributeMultipleInlineAttributes() {
        String xml = "<foo>\r\n\t<bar attr1=\"value1\" attr2=\"value2\">ABCD</bar>\r\n\t<baz attr1=\"baz-value1\" attr2=\"baz-value2\">EFGH</baz>\r\n\t<bar attr3=\"value3\" attr2=\"value2\">IJKL</bar>\r\n</foo>";
        String testURI = "file:///test/foo.xml";
        XMLSymbolSettings symbolSettings = new XMLSymbolSettings();
        XMLSymbolFilter filter = new XMLSymbolFilter();
        filter.setPattern("foo.xml");
        XMLSymbolExpressionFilter expressionFilter = new XMLSymbolExpressionFilter();
        XMLSymbolExpressionFilter expressionFilter2 = new XMLSymbolExpressionFilter();
        filter.setExpressions(new XMLSymbolExpressionFilter[]{expressionFilter, expressionFilter2});
        symbolSettings.setFilters(new XMLSymbolFilter[]{filter});
        expressionFilter.setXpath("//@attr1");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("//@attr3");
        expressionFilter2.setInlineAttribute(true);
        expressionFilter2.setShowAttributeName(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 6)), ""), XMLAssert.si("bar: value1", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz: baz-value1", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("bar: @attr3: value3", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(3, 1, 3, 46)), "foo"));
        expressionFilter.setXpath("//bar/@attr1");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("//bar/@attr3");
        expressionFilter2.setInlineAttribute(true);
        expressionFilter2.setShowAttributeName(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 6)), ""), XMLAssert.si("bar: value1", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("bar: @attr3: value3", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(3, 1, 3, 46)), "foo"));
        expressionFilter.setXpath("/foo/bar/@attr1");
        expressionFilter.setInlineAttribute(true);
        expressionFilter.setShowAttributeName(false);
        expressionFilter2.setXpath("/foo/bar/@attr3");
        expressionFilter2.setInlineAttribute(true);
        expressionFilter2.setShowAttributeName(true);
        XMLAssert.testSymbolInformationsFor(xml, testURI, symbolSettings, XMLAssert.si("foo", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(0, 0, 4, 6)), ""), XMLAssert.si("bar: value1", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(1, 1, 1, 46)), "foo"), XMLAssert.si("baz", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(2, 1, 2, 54)), "foo"), XMLAssert.si("bar: @attr3: value3", SymbolKind.Field, XMLAssert.l(testURI, XMLAssert.r(3, 1, 3, 46)), "foo"));
    }
}

