/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.completion;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLCompletionBasedOnRelaxNGWithCatalogTest
extends BaseFileTempTest {
    @Test
    public void completionInRoot() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n<|\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, 3, XMLAssert.c("teiHeader", XMLAssert.te(1, 0, 1, 1, "<teiHeader></teiHeader>"), "<teiHeader"));
    }

    @Test
    public void completionInDocumentElement() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n   <teiHeader>\r\n      <|\r\n    </teiHeader></TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, XMLAssert.c("fileDesc", XMLAssert.te(2, 6, 2, 7, "<fileDesc></fileDesc>"), "<fileDesc"));
    }

    @Test
    public void completionInAnElementAfter() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n   <teiHeader>\r\n      <fileDesc>\r\n         <titleStmt>\r\n         </titleStmt>\r\n         <|\r\n      </fileDesc>  \r\n   </teiHeader></TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, XMLAssert.c("publicationStmt", XMLAssert.te(5, 9, 5, 10, "<publicationStmt></publicationStmt>"), "<publicationStmt"), XMLAssert.c("editionStmt", XMLAssert.te(5, 9, 5, 10, "<editionStmt></editionStmt>"), "<editionStmt"), XMLAssert.c("extent", XMLAssert.te(5, 9, 5, 10, "<extent></extent>"), "<extent"));
    }

    @Test
    public void completionInAnElement() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n   <teiHeader>\r\n      <fileDesc>\r\n         <titleStmt>\r\n            <title>\r\n               <|\r\n            </title>\r\n         </titleStmt>\r\n      </fileDesc>  \r\n   </teiHeader></TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, XMLAssert.c("terrain", XMLAssert.te(5, 15, 5, 16, "<terrain></terrain>"), "<terrain"), XMLAssert.c("abbr", XMLAssert.te(5, 15, 5, 16, "<abbr></abbr>"), "<abbr"));
    }

    @Test
    public void completionWithRequiredAttributes() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n   <teiHeader>\r\n      <fileDesc>\r\n      </fileDesc>\r\n      <encodingDesc>\r\n         <appInfo>\r\n            <|\r\n         </appInfo>\r\n      </encodingDesc>\r\n   </teiHeader></TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, XMLAssert.c("application", XMLAssert.te(6, 12, 6, 13, "<application ident=\"\" version=\"\"></application>"), "<application"));
    }

    @Test
    public void completionForAttributeNames() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\" |>\r\n\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, XMLAssert.c("rend", XMLAssert.te(0, 41, 0, 41, "rend=\"\""), "rend"), XMLAssert.c("xml:space", XMLAssert.te(0, 41, 0, 41, "xml:space=\"\""), "xml:space"));
    }

    @Test
    public void completionForAttributeValues() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n   <teiHeader>\r\n     <fileDesc cert=\"|\">\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, 4, XMLAssert.c("high", XMLAssert.te(2, 21, 2, 21, "high"), "high"), XMLAssert.c("medium", XMLAssert.te(2, 21, 2, 21, "medium"), "medium"), XMLAssert.c("low", XMLAssert.te(2, 21, 2, 21, "low"), "low"), XMLAssert.c("unknown", XMLAssert.te(2, 21, 2, 21, "unknown"), "unknown"));
    }

    @Test
    public void completionForXMLSpaceAttributeValues() throws BadLocationException {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n   <teiHeader xml:space=\"|\">\r\n</TEI>";
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(xml, XMLAssert.c("preserve", XMLAssert.te(1, 25, 1, 25, "preserve"), "preserve"));
    }

    private static void testCompletionWithCatalogFor(String value, CompletionItem ... expectedItems) throws BadLocationException {
        XMLCompletionBasedOnRelaxNGWithCatalogTest.testCompletionWithCatalogFor(value, null, expectedItems);
    }

    private static void testCompletionWithCatalogFor(String value, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), value, "src/test/resources/relaxng/catalog-relaxng.xml", null, "src/test/resources/relaxng/test.xml", expectedCount, true, expectedItems);
    }
}

