/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.extensions.references.XMLReferencesSettingsForTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLReferencesCompletionExtensionsTest
extends BaseFileTempTest {
    @Test
    public void teiCorresp() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"body-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"|\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#body-id", XMLAssert.te(18, 23, 18, 23, "#body-id"), "#body-id"), XMLAssert.c("#p-id", XMLAssert.te(18, 23, 18, 23, "#p-id"), "#p-id"));
    }

    @Test
    public void teiTarget() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"|\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 16, 8, 16, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 16, 8, 16, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti1() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"|#A\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 16, 8, 18, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 16, 8, 18, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#|A\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 16, 8, 18, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 16, 8, 18, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti3() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A|\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 16, 8, 18, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 16, 8, 18, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti4() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A| \" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 16, 8, 19, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 16, 8, 19, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti5() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A| #B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 16, 8, 18, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 16, 8, 18, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti6() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A |#B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 19, 8, 21, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 19, 8, 21, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti7() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A #|B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 19, 8, 21, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 19, 8, 21, "#B"), "#B"));
    }

    @Test
    public void teiTargetMulti8() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A | #B\" />\r\n\t</text>\r\n</TEI>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/tei.xml", 2, XMLAssert.c("#A", XMLAssert.te(8, 19, 8, 19, "#A"), "#A"), XMLAssert.c("#B", XMLAssert.te(8, 19, 8, 19, "#B"), "#B"));
    }

    @Test
    public void docbook() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book>\r\n    <chapter id=\"chapter-1\">\r\n\r\n        <xref linkend=\"|\" />\r\n\r\n    </chapter>\r\n\r\n    <chapter id=\"chapter-2\">\r\n\r\n    </chapter>\r\n</book>";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/docbook.xml", 2, XMLAssert.c("chapter-1", XMLAssert.te(4, 23, 4, 23, "chapter-1"), "chapter-1"), XMLAssert.c("chapter-2", XMLAssert.te(4, 23, 4, 23, "chapter-2"), "chapter-2"));
    }

    @Test
    public void web() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  version=\"3.1\">\r\n  <servlet>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <servlet-class>mysite.server.ComingSoonServlet</servlet-class>\r\n  </servlet>\r\n  <servlet-mapping>\r\n    <servlet-name>co|m</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n</web-app>\r\n";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/web.xml", 3, XMLAssert.c("comingsoon", XMLAssert.te(8, 18, 8, 21, "comingsoon"), "comingsoon"));
    }

    @Test
    public void webInEmptyText() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  version=\"3.1\">\r\n  <servlet>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <servlet-class>mysite.server.ComingSoonServlet</servlet-class>\r\n  </servlet>\r\n  <servlet-mapping>\r\n    <servlet-name>|</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n</web-app>\r\n";
        XMLReferencesCompletionExtensionsTest.testCompletionFor(xml, "file:///test/web.xml", 3, XMLAssert.c("comingsoon", XMLAssert.te(8, 18, 8, 18, "comingsoon"), "comingsoon"));
    }

    private static void testCompletionFor(String value, String fileURI, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), value, null, (XMLLanguageService ls) -> ls.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(XMLReferencesSettingsForTest.createXMLReferencesSettings())), fileURI, expectedCount, true, expectedItems);
    }
}

