/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.concurrent.TimeUnit;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.DownloadDisabledResourceCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class XMLValidationExternalResourcesBasedOnDTDTest
extends AbstractCacheBasedTest {
    @Test
    public void docTypeDownloadDisabled() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        ls.initializeIfNeeded();
        ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
        contentModelManager.setDownloadExternalResources(false);
        String xml = "<!DOCTYPE root-element PUBLIC \"public-id\" \"http://localhost:8080/sample.dtd\">\r\n<root-element>\r\n</root-element>";
        String fileURI = "test.xml";
        Diagnostic d = new Diagnostic(XMLAssert.r(0, 43, 0, 75), "Downloading external resources is disabled.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadResourceDisabled.getCode());
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, d, new Diagnostic(XMLAssert.r(1, 1, 1, 13), "Element type \"root-element\" must be declared.", DiagnosticSeverity.Error, "xml", DTDErrorCode.MSG_ELEMENT_NOT_DECLARED.getCode())));
        XMLAssert.testCodeActionsFor(xml, fileURI, d, XMLAssert.ca(d, DownloadDisabledResourceCodeAction.createDownloadCommand((String)"Force download of 'http://localhost:8080/sample.dtd'.", (String)"http://localhost:8080/sample.dtd", (String)fileURI)));
    }

    @Test
    public void docTypeDownloadProblem() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String xml = "<!DOCTYPE root-element PUBLIC \"public-id\" \"http://localhost:8080/sample.dtd\">\r\n<root-element>\r\n</root-element>";
        String dtdCachePath = CacheResourcesManager.getResourceCachePath((String)"http://localhost:8080/sample.dtd").toString();
        String fileURI = "test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 43, 0, 75), "The resource 'http://localhost:8080/sample.dtd' is downloading in the cache path '" + dtdCachePath + "'.", DiagnosticSeverity.Information, "xml", ExternalResourceErrorCode.DownloadingResource.getCode()), new Diagnostic(XMLAssert.r(1, 1, 1, 13), "Element type \"root-element\" must be declared.", DiagnosticSeverity.Error, "xml", DTDErrorCode.MSG_ELEMENT_NOT_DECLARED.getCode())));
        TimeUnit.SECONDS.sleep(5L);
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 43, 0, 75), "Error while downloading 'http://localhost:8080/sample.dtd' to '" + dtdCachePath + "' : '[java.net.ConnectException] Connection refused'.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadProblem.getCode()), new Diagnostic(XMLAssert.r(1, 1, 1, 13), "Element type \"root-element\" must be declared.", DiagnosticSeverity.Error, "xml", DTDErrorCode.MSG_ELEMENT_NOT_DECLARED.getCode())));
    }

    @Test
    public void entityRefDownloadDisabled() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        ls.initializeIfNeeded();
        ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
        contentModelManager.setDownloadExternalResources(false);
        String xml = "<!DOCTYPE root-element [\r\n\t<!ELEMENT root-element (#PCDATA)>\r\n\t<!ENTITY % entity-name SYSTEM \"http://localhost:8080/sample.dtd\">\r\n\t%entity-name;\r\n]>\r\n<root-element>\r\n\t&abcd;\r\n</root-element>";
        String fileURI = "test.xml";
        Diagnostic d = new Diagnostic(XMLAssert.r(2, 32, 2, 64), "Downloading external resources is disabled.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadResourceDisabled.getCode());
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, d, new Diagnostic(XMLAssert.r(6, 1, 6, 7), "The entity \"abcd\" was referenced, but not declared.", DiagnosticSeverity.Error, "xml", DTDErrorCode.EntityNotDeclared.getCode())));
        XMLAssert.testCodeActionsFor(xml, fileURI, d, XMLAssert.ca(d, DownloadDisabledResourceCodeAction.createDownloadCommand((String)"Force download of 'http://localhost:8080/sample.dtd'.", (String)"http://localhost:8080/sample.dtd", (String)fileURI)));
    }

    @Test
    public void entityRefDownloadProblem() throws Exception {
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String xml = "<!DOCTYPE root-element [\r\n\t<!ELEMENT root-element (#PCDATA)>\r\n\t<!ENTITY % entity-name SYSTEM \"http://localhost:8080/sample.dtd\">\r\n\t%entity-name;\r\n]>\r\n<root-element>\r\n\t&abcd;\r\n</root-element>";
        String dtdCachePath = CacheResourcesManager.getResourceCachePath((String)"http://localhost:8080/sample.dtd").toString();
        String fileURI = "test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 32, 2, 64), "The resource 'http://localhost:8080/sample.dtd' is downloading in the cache path '" + dtdCachePath + "'.", DiagnosticSeverity.Information, "xml", ExternalResourceErrorCode.DownloadingResource.getCode()), new Diagnostic(XMLAssert.r(6, 1, 6, 7), "The entity \"abcd\" was referenced, but not declared.", DiagnosticSeverity.Error, "xml", DTDErrorCode.EntityNotDeclared.getCode())));
        TimeUnit.SECONDS.sleep(5L);
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 32, 2, 64), "Error while downloading 'http://localhost:8080/sample.dtd' to '" + dtdCachePath + "' : '[java.net.ConnectException] Connection refused'.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadProblem.getCode()), new Diagnostic(XMLAssert.r(6, 1, 6, 7), "The entity \"abcd\" was referenced, but not declared.", DiagnosticSeverity.Error, "xml", DTDErrorCode.EntityNotDeclared.getCode())));
    }
}

