/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.Range;
import org.junit.jupiter.api.Test;

public class XMLFileAssociationsHoverTest
extends AbstractCacheBasedTest {
    @Test
    public void hoverBasedOnXSDWithFileAssociation() throws BadLocationException, URI.MalformedURIException {
        ContentModelSettings modelSettings = new ContentModelSettings();
        modelSettings.setFileAssociations(XMLFileAssociationsHoverTest.createXSDAssociationsSchemaLocationLike("src/test/resources/xsd/"));
        String schemaURI = XMLFileAssociationsHoverTest.getXMLSchemaFileURI("maven-4.0.0.xsd");
        String xml = "<pro|ject xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n>\r\n</project>";
        XMLFileAssociationsHoverTest.assertHover(xml, "file:///test/pom.xml", modelSettings, "3.0.0+" + System.lineSeparator() + System.lineSeparator() + "The `<project>` element is the root of the descriptor. The following table lists all of the possible child elements." + System.lineSeparator() + System.lineSeparator() + "Source: [maven-4.0.0.xsd](" + schemaURI + ")", XMLAssert.r(0, 1, 0, 8));
    }

    @Test
    public void hoverBasedOnXSDWithFileAssociationAndDocType() throws BadLocationException, URI.MalformedURIException {
        ContentModelSettings modelSettings = new ContentModelSettings();
        modelSettings.setFileAssociations(XMLFileAssociationsHoverTest.createXSDAssociationsSchemaLocationLike("src/test/resources/xsd/"));
        String schemaURI = XMLFileAssociationsHoverTest.getXMLSchemaFileURI("maven-4.0.0.xsd");
        String xml = "<!DOCTYPE opt [\r\n  <!ENTITY size \"short\">\r\n]>\r\n<pro|ject xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n>\r\n</project>";
        XMLFileAssociationsHoverTest.assertHover(xml, "file:///test/pom.xml", modelSettings, "3.0.0+" + System.lineSeparator() + System.lineSeparator() + "The `<project>` element is the root of the descriptor. The following table lists all of the possible child elements." + System.lineSeparator() + System.lineSeparator() + "Source: [maven-4.0.0.xsd](" + schemaURI + ")", XMLAssert.r(3, 1, 3, 8));
    }

    private static XMLFileAssociation[] createXSDAssociationsSchemaLocationLike(String baseSystemId) {
        XMLFileAssociation maven = new XMLFileAssociation();
        maven.setPattern("**/pom.xml");
        maven.setSystemId(baseSystemId + "maven-4.0.0.xsd");
        return new XMLFileAssociation[]{maven};
    }

    private static void assertHover(String value, String fileURI, ContentModelSettings modelSettings, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        XMLAssert.assertHover(new XMLLanguageService(), value, null, fileURI, expectedHoverLabel, expectedHoverRange, modelSettings);
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }
}

