/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.commons.snippets.SnippetRegistry;
import org.eclipse.lemminx.customservice.AutoCloseTagResponse;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.ScannerState;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.services.CompletionRequest;
import org.eclipse.lemminx.services.CompletionResponse;
import org.eclipse.lemminx.services.ResolveCompletionItemRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.completion.DOMElementCompletionItem;
import org.eclipse.lemminx.services.extensions.completion.ElementEndTagCompletionResolver;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolveParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.services.snippets.IXMLSnippetContext;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XMLCompletions {
    private static final Logger LOGGER = Logger.getLogger(XMLCompletions.class.getName());
    private static final Pattern regionCompletionRegExpr = Pattern.compile("^(\\s*)(<(!(-(-\\s*(#\\w*)?)?)?)?)?$");
    private final XMLExtensionsRegistry extensionsRegistry;
    private SnippetRegistry snippetRegistry;
    private final ElementEndTagCompletionResolver endTagCompletionResolver;

    public XMLCompletions(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
        this.endTagCompletionResolver = new ElementEndTagCompletionResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionList doComplete(DOMDocument xmlDocument, Position position, SharedSettings settings, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        CompletionResponse completionResponse = new CompletionResponse();
        CompletionRequest completionRequest = null;
        try {
            completionRequest = new CompletionRequest(xmlDocument, position, settings, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of CompletionRequest failed", e);
            return completionResponse;
        }
        String text = xmlDocument.getText();
        int offset = completionRequest.getOffset();
        DOMNode node = completionRequest.getNode();
        try {
            if (text.isEmpty()) {
                this.collectInsideContent(completionRequest, completionResponse, cancelChecker);
                CompletionResponse completionResponse2 = completionResponse;
                return completionResponse2;
            }
            Scanner scanner = XMLScanner.createScanner(text, node.getStart(), XMLCompletions.isInsideDTDContent(node, xmlDocument));
            String currentTag = "";
            TokenType token = scanner.scan();
            while (token != TokenType.EOS && scanner.getTokenOffset() <= offset) {
                cancelChecker.checkCanceled();
                block23 : switch (token) {
                    case StartTagOpen: {
                        if (scanner.getTokenEnd() != offset) break;
                        int endPos = XMLCompletions.scanNextForEndPos(offset, scanner, TokenType.StartTag);
                        this.collectTagSuggestions(offset, endPos, completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse3 = completionResponse;
                        return completionResponse3;
                    }
                    case StartTag: {
                        CompletionResponse endPos;
                        if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
                            this.collectOpenTagSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd(), completionRequest, completionResponse, cancelChecker);
                            endPos = completionResponse;
                            return endPos;
                        }
                        currentTag = scanner.getTokenText();
                        break;
                    }
                    case AttributeName: {
                        if (scanner.getTokenOffset() > offset || offset > scanner.getTokenEnd()) break;
                        this.collectAttributeNameSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd(), completionRequest, completionResponse, cancelChecker);
                        CompletionResponse endPos = completionResponse;
                        return endPos;
                    }
                    case DelimiterAssign: {
                        if (scanner.getTokenEnd() != offset) break;
                        this.collectAttributeValueSuggestions(offset, offset, completionRequest, completionResponse, cancelChecker);
                        CompletionResponse endPos = completionResponse;
                        return endPos;
                    }
                    case DTDStartDoctypeTag: {
                        DTDDeclParameter systemId = xmlDocument.getDoctype().getSystemIdNode();
                        if (systemId == null || !DOMNode.isIncluded(systemId, offset)) break;
                        this.collectDTDSystemIdSuggestions(systemId.getStart(), systemId.getEnd(), completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse4 = completionResponse;
                        return completionResponse4;
                    }
                    case AttributeValue: {
                        if (scanner.getTokenOffset() > offset || offset > scanner.getTokenEnd()) break;
                        this.collectAttributeValueSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd(), completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse5 = completionResponse;
                        return completionResponse5;
                    }
                    case Whitespace: {
                        if (offset > scanner.getTokenEnd()) break;
                        switch (scanner.getScannerState()) {
                            case AfterOpeningStartTag: {
                                int startPos = scanner.getTokenOffset();
                                int endTagPos = XMLCompletions.scanNextForEndPos(offset, scanner, TokenType.StartTag);
                                this.collectTagSuggestions(startPos, endTagPos, completionRequest, completionResponse, cancelChecker);
                                CompletionResponse completionResponse6 = completionResponse;
                                return completionResponse6;
                            }
                            case WithinTag: 
                            case AfterAttributeName: {
                                this.collectAttributeNameSuggestions(scanner.getTokenEnd(), completionRequest, completionResponse, cancelChecker);
                                CompletionResponse completionResponse7 = completionResponse;
                                return completionResponse7;
                            }
                            case BeforeAttributeValue: {
                                this.collectAttributeValueSuggestions(scanner.getTokenEnd(), offset, completionRequest, completionResponse, cancelChecker);
                                CompletionResponse completionResponse8 = completionResponse;
                                return completionResponse8;
                            }
                            case AfterOpeningEndTag: {
                                this.collectCloseTagSuggestions(scanner.getTokenOffset() - 1, false, offset, completionRequest, completionResponse, cancelChecker);
                                CompletionResponse completionResponse9 = completionResponse;
                                return completionResponse9;
                            }
                            case WithinContent: {
                                this.collectInsideContent(completionRequest, completionResponse, cancelChecker);
                                CompletionResponse completionResponse10 = completionResponse;
                                return completionResponse10;
                            }
                        }
                        break;
                    }
                    case EndTagOpen: {
                        if (offset > scanner.getTokenEnd()) break;
                        int afterOpenBracket = scanner.getTokenOffset() + 1;
                        int endOffset = XMLCompletions.scanNextForEndPos(offset, scanner, TokenType.EndTag);
                        this.collectCloseTagSuggestions(afterOpenBracket, false, endOffset, completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse11 = completionResponse;
                        return completionResponse11;
                    }
                    case EndTag: {
                        if (offset > scanner.getTokenEnd()) break;
                        for (int start = scanner.getTokenOffset() - 1; start >= 0; --start) {
                            char ch = text.charAt(start);
                            if (ch == '/') {
                                this.collectCloseTagSuggestions(start, false, scanner.getTokenEnd(), completionRequest, completionResponse, cancelChecker);
                                CompletionResponse completionResponse12 = completionResponse;
                                return completionResponse12;
                            }
                            if (!Character.isWhitespace(ch)) break block23;
                        }
                        break;
                    }
                    case StartTagClose: {
                        if (offset > scanner.getTokenEnd() || currentTag == null || currentTag.length() <= 0) break;
                        this.collectInsideContent(completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse13 = completionResponse;
                        return completionResponse13;
                    }
                    case StartTagSelfClose: {
                        if (offset > scanner.getTokenEnd() || currentTag == null || currentTag.length() <= 0 || xmlDocument.getText().charAt(offset - 1) != '>') break;
                        this.collectInsideContent(completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse14 = completionResponse;
                        return completionResponse14;
                    }
                    case EndTagClose: {
                        if (offset > scanner.getTokenEnd() || currentTag == null || currentTag.length() <= 0) break;
                        this.collectInsideContent(completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse15 = completionResponse;
                        return completionResponse15;
                    }
                    case Content: {
                        if (completionRequest.getXMLDocument().isDTD() || completionRequest.getXMLDocument().isWithinInternalDTD(offset)) {
                            if (scanner.getTokenOffset() > offset) break;
                            CompletionResponse completionResponse16 = completionResponse;
                            return completionResponse16;
                        }
                        if (offset > scanner.getTokenEnd()) break;
                        this.collectInsideContent(completionRequest, completionResponse, cancelChecker);
                        CompletionResponse completionResponse17 = completionResponse;
                        return completionResponse17;
                    }
                    case DTDAttlistAttributeName: 
                    case DTDAttlistAttributeType: 
                    case DTDAttlistAttributeValue: 
                    case DTDStartAttlist: 
                    case DTDStartElement: 
                    case DTDStartEntity: 
                    case DTDEndTag: 
                    case DTDStartInternalSubset: 
                    case DTDEndInternalSubset: {
                        if (scanner.getTokenOffset() > offset) break;
                        CompletionResponse completionResponse18 = completionResponse;
                        return completionResponse18;
                    }
                    default: {
                        if (offset > scanner.getTokenEnd()) break;
                        CompletionResponse completionResponse19 = completionResponse;
                        return completionResponse19;
                    }
                }
                token = scanner.scan();
            }
            CompletionResponse completionResponse20 = completionResponse;
            return completionResponse20;
        }
        finally {
            this.collectSnippetSuggestions(completionRequest, completionResponse);
        }
    }

    public CompletionItem resolveCompletionItem(CompletionItem unresolved, DOMDocument xmlDocument, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        ResolveCompletionItemRequest request = new ResolveCompletionItemRequest(unresolved, xmlDocument, this.extensionsRegistry, sharedSettings);
        String participantId = request.getParticipantId();
        if (StringUtils.isEmpty(participantId)) {
            return unresolved;
        }
        if (ElementEndTagCompletionResolver.PARTICIPANT_ID.equals(participantId)) {
            try {
                return this.endTagCompletionResolver.resolveCompletionItem(request, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing resolve completion item for the participant '" + ElementEndTagCompletionResolver.class.getName() + "'.", e);
            }
        }
        for (ICompletionParticipant completionParticipant : this.extensionsRegistry.getCompletionParticipants()) {
            try {
                cancelChecker.checkCanceled();
                ICompletionItemResolveParticipant resolveCompletionItemParticipant = completionParticipant.getResolveCompletionItemParticipant(participantId);
                if (resolveCompletionItemParticipant == null) continue;
                return resolveCompletionItemParticipant.resolveCompletionItem(request, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing resolve completion item for the participant '" + completionParticipant.getClass().getName() + "'.", e);
            }
        }
        return unresolved;
    }

    private void collectSnippetSuggestions(CompletionRequest completionRequest, CompletionResponse completionResponse) {
        DOMDocument document = completionRequest.getXMLDocument();
        String text = document.getText();
        int endExpr = completionRequest.getOffset();
        int fromSearchExpr = XMLCompletions.getExprLimitStart(completionRequest.getNode(), endExpr);
        int startExpr = XMLCompletions.getExprStart(text, fromSearchExpr, endExpr);
        try {
            Range replaceRange = XMLCompletions.getReplaceRange(startExpr, endExpr, completionRequest);
            completionRequest.setReplaceRange(replaceRange);
            String lineDelimiter = document.lineDelimiter(replaceRange.getStart().getLine());
            List<CompletionItem> snippets = this.getSnippetRegistry().getCompletionItems(replaceRange, lineDelimiter, completionRequest.canSupportMarkupKind("markdown"), completionRequest.getSharedSettings().getCompletionSettings().isCompletionSnippetsSupported(), (context, model) -> {
                if (context instanceof IXMLSnippetContext) {
                    return ((IXMLSnippetContext)context).isMatch(completionRequest, (Map<String, String>)model);
                }
                return false;
            }, suffix -> {
                for (int i = endExpr; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (Character.isWhitespace(ch)) continue;
                    Integer eatIndex = XMLCompletions.getSuffixIndex(text, suffix, i);
                    if (eatIndex != null) {
                        try {
                            return document.positionAt(eatIndex);
                        }
                        catch (BadLocationException e) {
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            });
            for (CompletionItem completionItem : snippets) {
                completionResponse.addCompletionItem(completionItem);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In XMLCompletions, collectSnippetSuggestions position error", e);
        }
    }

    private static Integer getSuffixIndex(String text, String suffix, int initOffset) {
        int offset = initOffset;
        char ch = text.charAt(offset);
        Integer suffixIndex = null;
        for (int j = 0; j < suffix.length(); ++j) {
            if (suffix.charAt(j) != ch) continue;
            suffixIndex = j;
            break;
        }
        if (suffixIndex != null) {
            ++offset;
            if (suffixIndex.intValue() == suffix.length()) {
                return offset;
            }
            while (offset < text.length()) {
                Integer n = suffixIndex;
                Integer n2 = suffixIndex = Integer.valueOf(suffixIndex + 1);
                if (suffixIndex.intValue() == suffix.length()) {
                    return offset;
                }
                ch = text.charAt(offset);
                if (suffix.charAt(suffixIndex) != ch) {
                    return offset;
                }
                ++offset;
            }
            return offset;
        }
        return null;
    }

    private static int getExprLimitStart(DOMNode currentNode, int offset) {
        if (currentNode == null) {
            return 0;
        }
        if (currentNode.isText()) {
            return currentNode.getStart();
        }
        if (currentNode.isComment() || currentNode.isCDATA()) {
            if (offset >= currentNode.getEnd()) {
                return currentNode.isClosed() ? currentNode.getEnd() : currentNode.getStart();
            }
            return currentNode.getStart();
        }
        if (!currentNode.isElement()) {
            if (offset >= currentNode.getEnd() && currentNode.isClosed()) {
                return currentNode.getEnd();
            }
            return currentNode.getStart();
        }
        DOMElement element = (DOMElement)currentNode;
        if (element.isInStartTag(offset)) {
            return element.getStartTagOpenOffset();
        }
        if (element.isInEndTag(offset)) {
            return element.getEndTagOpenOffset();
        }
        if (offset >= currentNode.getEnd()) {
            return currentNode.getEnd();
        }
        return element.getStartTagCloseOffset() + 1;
    }

    private static int getExprStart(String value, int from, int to) {
        int index;
        if (to == 0) {
            return to;
        }
        for (index = to - 1; index > 0; --index) {
            if (Character.isWhitespace(value.charAt(index))) {
                return index + 1;
            }
            if (index > from) continue;
            return from;
        }
        return index;
    }

    private static boolean isInsideDTDContent(DOMNode node, DOMDocument xmlDocument) {
        if (xmlDocument.isDTD()) {
            return true;
        }
        return node.getParentNode() != null && node.getParentNode().isDoctype();
    }

    private boolean isBalanced(DOMNode node) {
        if (!node.isClosed()) {
            return false;
        }
        String name = node.getNodeName();
        for (DOMElement parent = node.getParentElement(); parent != null && name.equals(parent.getNodeName()); parent = parent.getParentElement()) {
            if (((DOMNode)parent).isClosed()) continue;
            return false;
        }
        return true;
    }

    public AutoCloseTagResponse doTagComplete(DOMDocument xmlDocument, Position position, XMLCompletionSettings completionSettings, CancelChecker cancelChecker) {
        int offset;
        try {
            offset = xmlDocument.offsetAt(position);
            if (offset - 2 < 0) {
                return null;
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "doTagComplete failed", e);
            return null;
        }
        if (offset <= 0) {
            return null;
        }
        char c = xmlDocument.getText().charAt(offset - 1);
        char cBefore = xmlDocument.getText().charAt(offset - 2);
        String snippet = null;
        if (XMLPositionUtility.isInAttributeValue(xmlDocument, position)) {
            return null;
        }
        if (c == '>') {
            DOMNode node = xmlDocument.findNodeBefore(offset);
            if (!(node instanceof DOMElement)) {
                return null;
            }
            DOMElement element = (DOMElement)node;
            if (node != null && node.isElement() && !element.isSelfClosed() && element.hasTagName() && !this.isEmptyElement(((DOMElement)node).getTagName()) && node.getStart() < offset && (!element.hasEndTag() || element.getTagName().equals(node.getParentNode().getNodeName()) && !this.isBalanced(node))) {
                snippet = "$0</" + ((DOMElement)node).getTagName() + ">";
            }
        } else if (cBefore == '<' && c == '/') {
            DOMNode node;
            for (node = xmlDocument.findNodeBefore(offset); node != null && (node.isClosed() || node.isElement() && ((DOMElement)node).isOrphanEndTag()); node = node.getParentNode()) {
            }
            if (node != null && node.isElement() && ((DOMElement)node).getTagName() != null) {
                snippet = ((DOMElement)node).getTagName() + ">$0";
            }
        } else {
            DOMNode node = xmlDocument.findNodeBefore(offset);
            if (node.isElement() && node.getNodeName() != null) {
                DOMElement element1 = (DOMElement)node;
                Integer slashOffset = element1.endsWith('/', offset);
                Position end = null;
                if (!element1.isInEndTag(offset) && slashOffset != null) {
                    boolean closeBracketAfterSlash;
                    String text;
                    List<DOMAttr> attrList = element1.getAttributeNodes();
                    if (attrList != null) {
                        DOMAttr lastAttr = attrList.get(attrList.size() - 1);
                        if (slashOffset < lastAttr.getEnd()) {
                            return null;
                        }
                    }
                    boolean bl = offset < (text = xmlDocument.getText()).length() ? text.charAt(offset) == '>' : (closeBracketAfterSlash = false);
                    if (!closeBracketAfterSlash) {
                        if (element1.isStartTagClosed()) {
                            return null;
                        }
                        snippet = ">$0";
                        if (element1.hasEndTag() && completionSettings.isAutoCloseRemovesContent()) {
                            try {
                                end = xmlDocument.positionAt(element1.getEnd());
                            }
                            catch (BadLocationException e) {
                                return null;
                            }
                        }
                    } else {
                        DOMNode nodeAfterParent;
                        DOMElement parentElement;
                        DOMNode nextSibling = node.getNextSibling();
                        if (nextSibling != null && nextSibling.isElement()) {
                            DOMElement element2 = (DOMElement)nextSibling;
                            if (!element2.hasStartTag() && node.getNodeName().equals(element2.getNodeName())) {
                                try {
                                    snippet = ">$0";
                                    end = xmlDocument.positionAt(element2.getEnd());
                                }
                                catch (BadLocationException e) {
                                    return null;
                                }
                            }
                        } else if (nextSibling == null && (parentElement = node.getParentElement()) != null && node.getNodeName().equals(parentElement.getTagName()) && (nodeAfterParent = parentElement.getNextSibling()) != null && nodeAfterParent.isElement()) {
                            DOMElement elementAfterParent = (DOMElement)nodeAfterParent;
                            if (parentElement.getTagName().equals(elementAfterParent.getTagName()) && !elementAfterParent.hasStartTag()) {
                                try {
                                    snippet = ">$0";
                                    end = xmlDocument.positionAt(parentElement.getEnd());
                                }
                                catch (BadLocationException e) {
                                    return null;
                                }
                            }
                        }
                    }
                    if (snippet != null && end != null) {
                        return new AutoCloseTagResponse(snippet, new Range(position, end));
                    }
                }
            }
        }
        if (snippet == null) {
            return null;
        }
        return new AutoCloseTagResponse(snippet);
    }

    private void collectTagSuggestions(int tagStart, int tagEnd, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        this.collectOpenTagSuggestions(tagStart, tagEnd, completionRequest, completionResponse, cancelChecker);
        this.collectCloseTagSuggestions(tagStart, true, tagEnd, completionRequest, completionResponse, cancelChecker);
    }

    private void collectOpenTagSuggestions(int afterOpenBracket, int tagNameEnd, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        try {
            Range replaceRange = XMLCompletions.getReplaceRange(afterOpenBracket - 1, tagNameEnd, completionRequest);
            this.collectOpenTagSuggestions(true, replaceRange, completionRequest, completionResponse, cancelChecker);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions the provided offset was a BadLocation", e);
            return;
        }
    }

    private void collectOpenTagSuggestions(boolean hasOpenBracket, Range replaceRange, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        try {
            DOMDocument document = completionRequest.getXMLDocument();
            String text = document.getText();
            int tagNameEnd = document.offsetAt(replaceRange.getEnd());
            int newOffset = XMLCompletions.getOffsetFollowedBy(text, tagNameEnd, ScannerState.WithinEndTag, TokenType.EndTagClose);
            if (newOffset != -1) {
                replaceRange.setEnd(document.positionAt(++newOffset));
            }
        }
        catch (BadLocationException document) {
            // empty catch block
        }
        completionRequest.setHasOpenBracket(hasOpenBracket);
        completionRequest.setReplaceRange(replaceRange);
        for (ICompletionParticipant participant : this.getCompletionParticipants()) {
            try {
                participant.onTagOpen(completionRequest, completionResponse, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onTagOpen for participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        DOMElement parentNode = completionRequest.getParentElement();
        if (parentNode != null && !parentNode.getOwnerDocument().hasGrammar()) {
            HashSet seenElements = new HashSet();
            if (parentNode != null && parentNode.isElement() && parentNode.hasChildNodes()) {
                parentNode.getChildren().forEach(node -> {
                    DOMElement element;
                    DOMElement dOMElement = element = node.isElement() ? (DOMElement)node : null;
                    if (element == null || element.getTagName() == null || seenElements.contains(element.getTagName())) {
                        return;
                    }
                    String tag = element.getTagName();
                    seenElements.add(tag);
                    DOMElementCompletionItem item = new DOMElementCompletionItem(element, completionRequest);
                    completionResponse.addCompletionItem(item);
                });
            }
        }
    }

    private void collectCloseTagSuggestions(int afterOpenBracket, boolean inOpenTag, int tagNameEnd, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        try {
            Range range = XMLCompletions.getReplaceRange(afterOpenBracket, tagNameEnd, completionRequest);
            String text = completionRequest.getXMLDocument().getText();
            boolean hasCloseTag = XMLCompletions.isFollowedBy(text, tagNameEnd, ScannerState.WithinEndTag, TokenType.EndTagClose);
            this.collectCloseTagSuggestions(range, false, !hasCloseTag, inOpenTag, completionRequest, completionResponse);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions the provided offset was a BadLocation", e);
        }
    }

    private void collectCloseTagSuggestions(Range range, boolean openEndTag, boolean closeEndTag, boolean inOpenTag, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        try {
            String text = completionRequest.getXMLDocument().getText();
            DOMNode curr = completionRequest.getNode();
            if (inOpenTag) {
                curr = curr.getParentNode();
            }
            String closeTag = closeEndTag ? ">" : "";
            int afterOpenBracket = completionRequest.getXMLDocument().offsetAt(range.getStart());
            if (!openEndTag) {
                --afterOpenBracket;
            }
            int offset = completionRequest.getOffset();
            while (curr != null) {
                DOMElement element;
                String tag;
                if (curr.isElement() && (tag = (element = (DOMElement)curr).getTagName()) != null && !element.isClosed()) {
                    CompletionItem item = new CompletionItem();
                    item.setLabel("End with '</" + tag + ">'");
                    item.setKind(CompletionItemKind.Property);
                    item.setInsertTextFormat(InsertTextFormat.PlainText);
                    String startIndent = XMLCompletions.getLineIndent(element.getStart(), text);
                    String endIndent = XMLCompletions.getLineIndent(afterOpenBracket, text);
                    if (startIndent != null && endIndent != null && !startIndent.equals(endIndent)) {
                        String insertText = startIndent + "</" + tag + closeTag;
                        item.setTextEdit(Either.forLeft((Object)new TextEdit(XMLCompletions.getReplaceRange(afterOpenBracket - endIndent.length(), offset, completionRequest), insertText)));
                        item.setFilterText(endIndent + "</" + tag + closeTag);
                    } else {
                        String openTag = openEndTag ? "<" : "";
                        String insertText = openTag + "/" + tag + closeTag;
                        item.setFilterText(insertText);
                        item.setTextEdit(Either.forLeft((Object)new TextEdit(range, insertText)));
                    }
                    completionResponse.addCompletionItem(item);
                }
                curr = curr.getParentNode();
            }
            if (inOpenTag) {
                return;
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions the provided offset was a BadLocation", e);
        }
    }

    private void collectInsideContent(CompletionRequest request, CompletionResponse response, CancelChecker cancelChecker) {
        Range textRange;
        Range tagNameRange = request.getXMLDocument().getElementNameRangeAt(request.getOffset());
        if (tagNameRange != null) {
            this.collectOpenTagSuggestions(false, tagNameRange, request, response, cancelChecker);
            this.collectCloseTagSuggestions(tagNameRange, true, true, false, request, response);
        }
        if ((textRange = XMLCompletions.getTextRangeInsideContent(request.getNode())) != null) {
            request.setReplaceRange(textRange);
        }
        for (ICompletionParticipant participant : this.getCompletionParticipants()) {
            try {
                participant.onXMLContent(request, response, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onXMLContent for participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        this.collectionRegionProposals(request, response);
    }

    private static Range getTextRangeInsideContent(DOMNode node) {
        switch (node.getNodeType()) {
            case 1: {
                DOMNode firstChild = node.getFirstChild();
                if (firstChild == null) {
                    DOMElement element = (DOMElement)node;
                    return XMLPositionUtility.createRange(element.getStartTagCloseOffset() + 1, element.getStartTagCloseOffset() + 1, element.getOwnerDocument());
                }
                if (firstChild.getNodeType() == 3) {
                    return XMLPositionUtility.selectText((DOMText)firstChild);
                }
                return null;
            }
            case 3: {
                return XMLPositionUtility.selectText((DOMText)node);
            }
        }
        return null;
    }

    private void collectionRegionProposals(ICompletionRequest request, ICompletionResponse response) {
        try {
            int offset = request.getOffset();
            TextDocument document = request.getXMLDocument().getTextDocument();
            Position pos = document.positionAt(offset);
            String lineText = document.lineText(pos.getLine());
            String lineUntilPos = lineText.substring(0, pos.getCharacter());
            Matcher match = regionCompletionRegExpr.matcher(lineUntilPos);
            if (match.find()) {
                InsertTextFormat insertFormat = request.getInsertTextFormat();
                Range range = new Range(new Position(pos.getLine(), pos.getCharacter() + match.regionStart()), pos);
                String text = request.isCompletionSnippetsSupported() ? "<!-- #region $1-->" : "<!-- #region -->";
                CompletionItem beginProposal = new CompletionItem("#region");
                beginProposal.setTextEdit(Either.forLeft((Object)new TextEdit(range, text)));
                beginProposal.setDocumentation("Insert Folding Region Start");
                beginProposal.setFilterText(match.group());
                beginProposal.setSortText("za");
                beginProposal.setKind(CompletionItemKind.Snippet);
                beginProposal.setInsertTextFormat(insertFormat);
                response.addCompletionAttribute(beginProposal);
                CompletionItem endProposal = new CompletionItem("#endregion");
                endProposal.setTextEdit(Either.forLeft((Object)new TextEdit(range, "<!-- #endregion-->")));
                endProposal.setDocumentation("Insert Folding Region End");
                endProposal.setFilterText(match.group());
                endProposal.setSortText("zb");
                endProposal.setKind(CompletionItemKind.Snippet);
                endProposal.setInsertTextFormat(InsertTextFormat.PlainText);
                response.addCompletionAttribute(endProposal);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing collectRegionCompletion", e);
        }
    }

    private void collectAttributeNameSuggestions(int nameStart, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        this.collectAttributeNameSuggestions(nameStart, completionRequest.getOffset(), completionRequest, completionResponse, cancelChecker);
    }

    private void collectAttributeNameSuggestions(int nameStart, int nameEnd, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        int replaceEnd;
        String text = completionRequest.getXMLDocument().getText();
        for (replaceEnd = completionRequest.getOffset(); replaceEnd < nameEnd && text.charAt(replaceEnd) != '<' && text.charAt(replaceEnd) != '?'; ++replaceEnd) {
        }
        try {
            Range replaceRange = XMLCompletions.getReplaceRange(nameStart, replaceEnd, completionRequest);
            completionRequest.setReplaceRange(replaceRange);
            boolean generateValue = !XMLCompletions.isFollowedBy(text, nameEnd, ScannerState.AfterAttributeName, TokenType.DelimiterAssign);
            for (ICompletionParticipant participant : this.getCompletionParticipants()) {
                try {
                    participant.onAttributeName(generateValue, completionRequest, completionResponse, cancelChecker);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onAttributeName for participant '" + participant.getClass().getName() + "'.", e);
                }
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions, getReplaceRange() was given a bad Offset location", e);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onAttributeName", e);
        }
    }

    private void collectAttributeValueSuggestions(int valueStart, int valueEnd, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        String valuePrefix;
        boolean addQuotes = false;
        int offset = completionRequest.getOffset();
        String text = completionRequest.getXMLDocument().getText();
        if (offset > valueStart && offset <= valueEnd && StringUtils.isQuote(text.charAt(valueStart))) {
            int valueContentStart = valueStart + 1;
            int valueContentEnd = valueEnd;
            if (text.charAt(valueEnd - 1) == text.charAt(valueStart)) {
                --valueContentEnd;
            }
            valuePrefix = offset >= valueContentStart && offset <= valueContentEnd ? text.substring(valueContentStart, offset) : "";
            valueStart = valueContentStart;
            valueEnd = valueContentEnd;
            addQuotes = false;
        } else {
            valuePrefix = text.substring(valueStart, offset);
            addQuotes = true;
        }
        Collection<ICompletionParticipant> completionParticipants = this.getCompletionParticipants();
        if (completionParticipants.size() > 0) {
            try {
                Range replaceRange = XMLCompletions.getReplaceRange(valueStart, valueEnd, completionRequest);
                completionRequest.setReplaceRange(replaceRange);
                completionRequest.setAddQuotes(addQuotes);
                for (ICompletionParticipant participant : completionParticipants) {
                    try {
                        participant.onAttributeValue(valuePrefix, completionRequest, completionResponse, cancelChecker);
                    }
                    catch (CancellationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onAttributeValue for participant '" + participant.getClass().getName() + "'.", e);
                    }
                }
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "While performing Completions, getReplaceRange() was given a bad Offset location", e);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onAttributeValue", e);
            }
        }
    }

    private void collectDTDSystemIdSuggestions(int valueStart, int valueEnd, CompletionRequest completionRequest, CompletionResponse completionResponse, CancelChecker cancelChecker) {
        int offset = completionRequest.getOffset();
        String text = completionRequest.getXMLDocument().getText();
        int valueContentStart = valueStart + 1;
        int valueContentEnd = valueEnd - 1;
        String valuePrefix = offset >= valueContentStart && offset <= valueContentEnd ? text.substring(valueContentStart, offset) : "";
        Collection<ICompletionParticipant> completionParticipants = this.getCompletionParticipants();
        if (completionParticipants.size() > 0) {
            try {
                Range replaceRange = XMLCompletions.getReplaceRange(valueContentStart, valueContentEnd, completionRequest);
                completionRequest.setReplaceRange(replaceRange);
                for (ICompletionParticipant participant : completionParticipants) {
                    try {
                        participant.onDTDSystemId(valuePrefix, completionRequest, completionResponse, cancelChecker);
                    }
                    catch (CancellationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onDTDSystemId for participant '" + participant.getClass().getName() + "'.", e);
                    }
                }
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "While performing Completions, getReplaceRange() was given a bad Offset location", e);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onDTDSystemId", e);
            }
        }
    }

    private static int scanNextForEndPos(int offset, Scanner scanner, TokenType nextToken) {
        TokenType token;
        if (offset == scanner.getTokenEnd() && (token = scanner.scan()) == nextToken && scanner.getTokenOffset() == offset) {
            return scanner.getTokenEnd();
        }
        return offset;
    }

    private Collection<ICompletionParticipant> getCompletionParticipants() {
        return this.extensionsRegistry.getCompletionParticipants();
    }

    private static boolean isFollowedBy(String s, int offset, ScannerState intialState, TokenType expectedToken) {
        return XMLCompletions.getOffsetFollowedBy(s, offset, intialState, expectedToken) != -1;
    }

    public static int getOffsetFollowedBy(String s, int offset, ScannerState intialState, TokenType expectedToken) {
        Scanner scanner = XMLScanner.createScanner(s, offset, intialState);
        TokenType token = scanner.scan();
        while (token == TokenType.Whitespace) {
            token = scanner.scan();
        }
        return token == expectedToken ? scanner.getTokenOffset() : -1;
    }

    private static Range getReplaceRange(int replaceStart, int replaceEnd, ICompletionRequest context) throws BadLocationException {
        int offset = context.getOffset();
        if (replaceStart > offset) {
            replaceStart = offset;
        }
        DOMDocument document = context.getXMLDocument();
        return XMLPositionUtility.createRange(replaceStart, replaceEnd, document);
    }

    private static String getLineIndent(int offset, String text) {
        for (int start = offset; start > 0; --start) {
            char ch = text.charAt(start - 1);
            if ("\n\r".indexOf(ch) >= 0) {
                return text.substring(start, offset);
            }
            if (Character.isWhitespace(ch)) continue;
            return null;
        }
        return text.substring(0, offset);
    }

    private boolean isEmptyElement(String tag) {
        return false;
    }

    private SnippetRegistry getSnippetRegistry() {
        if (this.snippetRegistry == null) {
            this.snippetRegistry = new SnippetRegistry();
        }
        return this.snippetRegistry;
    }
}

