/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsi;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.xsi.settings.XSISchemaLocationSplit;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.junit.jupiter.api.Test;

public class XSIFormatterLegacyTest
extends AbstractCacheBasedTest {
    @Test
    public void xsiSchemaLocationSplitNone() throws BadLocationException {
        String content;
        SharedSettings settings = XSIFormatterLegacyTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.none, (XMLFormattingOptions)settings.getFormattingSettings());
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        XMLAssert.assertFormat(content, expected, settings);
        settings = XSIFormatterLegacyTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.none, (XMLFormattingOptions)settings.getFormattingSettings());
        XMLAssert.assertFormat(content, expected, settings);
    }

    @Test
    public void xsiSchemaLocationSplitOnElement() throws BadLocationException {
        SharedSettings settings = XSIFormatterLegacyTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n                        http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                        http://www.springframework.org/schema/util\r\n                        http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        XMLAssert.assertFormat(content, expected, settings);
    }

    @Test
    public void xsiSchemaLocationSplitOnPair() throws BadLocationException {
        SharedSettings settings = XSIFormatterLegacyTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onPair, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        XMLAssert.assertFormat(content, expected, settings);
    }

    @Test
    public void xsiSchemaLocationEmpty() throws BadLocationException {
        SharedSettings settings = XSIFormatterLegacyTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=</beans>";
        XMLAssert.assertFormat(content, content, settings);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"</beans>";
        XMLAssert.assertFormat(content, content, settings);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\"</beans>";
        XMLAssert.assertFormat(content, content, settings);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabs() throws BadLocationException {
        SharedSettings settings = XSIFormatterLegacyTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n\t\txmlns=\"http://www.springframework.org/schema/beans\"\r\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\t\txmlns:util=\"http://www.springframework.org/schema/util\"\r\n\t\txsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\t\thttp://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\t\thttp://www.springframework.org/schema/util\r\n\t\t\t\t\t\t\thttp://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        XMLAssert.assertFormat(content, expected, settings);
    }

    private static SharedSettings createSettings() {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(2);
        settings.getFormattingSettings().setSplitAttributes(true);
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        settings.getFormattingSettings().setLegacy(true);
        return settings;
    }
}

