/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.client.CodeLensKindCapabilities;
import org.eclipse.lemminx.client.ExtendedCodeLensCapabilities;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.customservice.AutoCloseTagResponse;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.colors.settings.XMLColorsSettings;
import org.eclipse.lemminx.extensions.contentmodel.commands.SurroundWithCommand;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLSchemaSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorManager;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.services.IXMLFullFormatter;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.services.extensions.save.AbstractSaveContext;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.settings.capabilities.CompletionResolveSupportProperty;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.TextEditUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionItemResolveSupportCapabilities;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Assertions;

public class XMLAssert {
    public static final int COMMENT_SNIPPETS = 1;
    public static final int CDATA_SNIPPETS = 1;
    public static final int DOCTYPE_SNIPPETS = 5;
    public static final int DTDNODE_SNIPPETS = 4;
    public static final int NEW_XML_SNIPPETS = 8;
    public static final int NEW_XSD_SNIPPETS = 1;
    public static final int XML_DECLARATION_SNIPPETS = 2;
    public static final int PROCESSING_INSTRUCTION_SNIPPETS = 4;
    public static final int REGION_SNIPPETS = 2;
    public static final int CATALOG_SNIPPETS = 3;
    private static final String FILE_URI = "test.xml";
    private static final CancelChecker NULL_CHECKER = () -> {};
    private static final Function<String, String> cleanExceptionMessage = message -> {
        if (message.contains("[")) {
            String exceptionClassName = message.substring(message.indexOf("[") + 1, message.indexOf("]"));
            message = message.split("\\s:\\s")[0] + " : " + exceptionClassName;
        }
        return message;
    };

    public static CompletionList testCompletionFor(String value, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLAssert.testCompletionFor(value, null, expectedItems);
    }

    public static CompletionList testCompletionFor(String value, String catalogPath, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLAssert.testCompletionFor(value, catalogPath, null, null, expectedItems);
    }

    public static CompletionList testCompletionFor(String value, int expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLAssert.testCompletionFor(value, null, null, expectedCount, expectedItems);
    }

    public static CompletionList testCompletionFor(String value, String catalogPath, String fileURI, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLAssert.testCompletionFor(new XMLLanguageService(), value, catalogPath, null, fileURI, expectedCount, true, expectedItems);
    }

    public static CompletionList testCompletionFor(String value, boolean autoCloseTags, CompletionItem ... expectedItems) throws BadLocationException {
        return XMLAssert.testCompletionFor(new XMLLanguageService(), value, null, null, null, null, autoCloseTags, expectedItems);
    }

    public static CompletionList testCompletionFor(XMLLanguageService xmlLanguageService, String value, String catalogPath, Consumer<XMLLanguageService> customConfiguration, String fileURI, Integer expectedCount, boolean autoCloseTags, CompletionItem ... expectedItems) throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(autoCloseTags);
        return XMLAssert.testCompletionFor(xmlLanguageService, value, catalogPath, customConfiguration, fileURI, expectedCount, settings, expectedItems);
    }

    public static CompletionList testCompletionFor(XMLLanguageService xmlLanguageService, String value, String catalogPath, Consumer<XMLLanguageService> customConfiguration, String fileURI, Integer expectedCount, SharedSettings sharedSettings, CompletionItem ... expectedItems) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        DOMDocument htmlDoc = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> htmlDoc);
        ContentModelSettings cmSettings = new ContentModelSettings();
        cmSettings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            cmSettings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(cmSettings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        CompletionList list = xmlLanguageService.doComplete(htmlDoc, position, sharedSettings);
        List labels = list.getItems().stream().map(i -> i.getLabel()).sorted().collect(Collectors.toList());
        String previous = null;
        for (String label : labels) {
            if (expectedCount != null) continue;
            Assertions.assertNotEquals(previous, (Object)label, () -> "Duplicate label " + label + " in " + labels.stream().collect(Collectors.joining(",")) + "}");
            previous = label;
        }
        if (expectedCount != null) {
            Assertions.assertEquals((int)expectedCount, (int)list.getItems().size());
        }
        if (expectedItems != null) {
            for (CompletionItem item : expectedItems) {
                XMLAssert.assertCompletion(list, item, expectedCount);
            }
        }
        return list;
    }

    public static void assertCompletion(CompletionList completions, CompletionItem expected, Integer expectedCount) {
        List<CompletionItem> matches = completions.getItems().stream().filter(completion -> expected.getLabel().equals(completion.getLabel())).collect(Collectors.toList());
        if (expectedCount != null) {
            Assertions.assertTrue((matches.size() >= 1 ? 1 : 0) != 0, () -> expected.getLabel() + " should only exist once: Actual: " + completions.getItems().stream().map(c -> c.getLabel()).collect(Collectors.joining(",")));
        } else {
            Assertions.assertEquals((int)1, (int)matches.size(), () -> expected.getLabel() + " should only exist once: Actual: " + completions.getItems().stream().map(c -> c.getLabel()).collect(Collectors.joining(",")));
        }
        CompletionItem match = XMLAssert.getCompletionMatch(matches, expected);
        if (expected.getTextEdit() != null && match.getTextEdit() != null) {
            Range r;
            if (((TextEdit)expected.getTextEdit().getLeft()).getNewText() != null) {
                Assertions.assertEquals((Object)((TextEdit)expected.getTextEdit().getLeft()).getNewText(), (Object)((TextEdit)match.getTextEdit().getLeft()).getNewText());
            }
            if ((r = ((TextEdit)expected.getTextEdit().getLeft()).getRange()) != null && r.getStart() != null && r.getEnd() != null) {
                Assertions.assertEquals((Object)((TextEdit)expected.getTextEdit().getLeft()).getRange(), (Object)((TextEdit)match.getTextEdit().getLeft()).getRange());
            }
            if (expected.getAdditionalTextEdits() != null) {
                List matchedAdditionalTextEdits = match.getAdditionalTextEdits() != null ? match.getAdditionalTextEdits() : Collections.emptyList();
                Assertions.assertEquals((int)expected.getAdditionalTextEdits().size(), (int)matchedAdditionalTextEdits.size());
                Assertions.assertArrayEquals((Object[])expected.getAdditionalTextEdits().toArray(), (Object[])matchedAdditionalTextEdits.toArray());
            }
        }
        if (expected.getFilterText() != null && match.getFilterText() != null) {
            Assertions.assertEquals((Object)expected.getFilterText(), (Object)match.getFilterText());
        }
        if (expected.getDocumentation() != null) {
            Assertions.assertEquals((Object)expected.getDocumentation(), (Object)match.getDocumentation());
        }
    }

    public static void testCompletionApply(String value, CompletionItem completionItem, String expected) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, FILE_URI);
        ArrayList<Object> edits = new ArrayList<Object>();
        edits.add(completionItem.getTextEdit().getLeft());
        if (completionItem.getAdditionalTextEdits() != null) {
            edits.addAll(completionItem.getAdditionalTextEdits());
        }
        String actual = TextEditUtils.applyEdits((TextDocument)document, edits);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertAdditionalTextEdit(List<TextEdit> matches, TextEdit expected) {
        for (TextEdit match : matches) {
            if (expected.getNewText() == null || !expected.getNewText().equals(match.getNewText())) continue;
            Range r = expected.getRange();
            if (r != null && r.getStart() != null && r.getEnd() != null) {
                Assertions.assertEquals((Object)expected.getRange(), (Object)match.getRange());
            }
            return;
        }
        Assertions.fail((String)("No AdditionalTextEdit match found for " + expected.toString()));
    }

    private static CompletionItem getCompletionMatch(List<CompletionItem> matches, CompletionItem expected) {
        for (CompletionItem item : matches) {
            if (!((TextEdit)expected.getTextEdit().getLeft()).getNewText().equals(((TextEdit)item.getTextEdit().getLeft()).getNewText())) continue;
            return item;
        }
        return matches.get(0);
    }

    public static CompletionItem c(String label, TextEdit textEdit, String filterText, String documentation) {
        return XMLAssert.c(label, textEdit, filterText, documentation, null);
    }

    public static CompletionItem c(String label, TextEdit textEdit, String filterText, String documentation, String kind) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setFilterText(filterText);
        item.setTextEdit(Either.forLeft((Object)textEdit));
        if (kind == null) {
            item.setDocumentation(documentation);
        } else {
            item.setDocumentation(new MarkupContent(kind, documentation));
        }
        return item;
    }

    public static CompletionItem c(String label, TextEdit textEdit, String filterText) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setFilterText(filterText);
        item.setTextEdit(Either.forLeft((Object)textEdit));
        return item;
    }

    public static CompletionItem c(String label, TextEdit textEdit, List<TextEdit> additionalTextEdits, String filterText) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        item.setFilterText(filterText);
        item.setTextEdit(Either.forLeft((Object)textEdit));
        item.setAdditionalTextEdits(additionalTextEdits);
        return item;
    }

    public static CompletionItem c(String label, String newText) {
        return XMLAssert.c(label, newText, null);
    }

    public static CompletionItem c(String label, String newText, String filterText) {
        return XMLAssert.c(label, newText, new Range(), filterText);
    }

    public static CompletionItem c(String label, String newText, Range range, String filterText) {
        return XMLAssert.c(label, new TextEdit(range, newText), filterText);
    }

    public static void testTagCompletion(String value, String expected) throws BadLocationException {
        XMLAssert.testTagCompletion(value, expected, new SharedSettings());
    }

    public static void testTagCompletion(String value, String expected, SharedSettings settings) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        XMLLanguageService ls = new XMLLanguageService();
        TextDocument document = new TextDocument(value, "test://test/test.html");
        Position position = document.positionAt(offset);
        DOMDocument htmlDoc = DOMParser.getInstance().parse(document, ls.getResolverExtensionManager());
        AutoCloseTagResponse response = ls.doTagComplete(htmlDoc, settings.getCompletionSettings(), position);
        if (expected == null) {
            Assertions.assertNull((Object)response);
            return;
        }
        String actual = response.snippet;
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static void testTagCompletion(String value, AutoCloseTagResponse expected, SharedSettings settings) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        XMLLanguageService ls = new XMLLanguageService();
        TextDocument document = new TextDocument(value, "test://test/test.html");
        Position position = document.positionAt(offset);
        DOMDocument htmlDoc = DOMParser.getInstance().parse(document, ls.getResolverExtensionManager());
        AutoCloseTagResponse actual = ls.doTagComplete(htmlDoc, settings.getCompletionSettings(), position);
        if (expected == null) {
            Assertions.assertNull((Object)actual);
            return;
        }
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)expected.snippet, (Object)actual.snippet);
        Assertions.assertEquals((Object)expected.range, (Object)actual.range);
    }

    public static void testCompletionItemUnresolvedFor(String value, String catalogPath, String fileURI, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionItemResolveSupportCapabilities completionItemResolveSupportCapabilities = new CompletionItemResolveSupportCapabilities();
        completionItemResolveSupportCapabilities.setProperties(Arrays.asList(CompletionResolveSupportProperty.documentation.name(), CompletionResolveSupportProperty.additionalTextEdits.name()));
        CompletionItemCapabilities completionItemCapabilities = new CompletionItemCapabilities();
        completionItemCapabilities.setResolveSupport(completionItemResolveSupportCapabilities);
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        completionCapabilities.setCompletionItem(completionItemCapabilities);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        XMLAssert.testCompletionItemUnresolvedFor(new XMLLanguageService(), value, catalogPath, (XMLLanguageService _a) -> {}, fileURI, expectedCount, sharedSettings, expectedItems);
    }

    public static void testCompletionItemUnresolvedFor(XMLLanguageService xmlLanguageService, String value, String catalogPath, Consumer<XMLLanguageService> customConfiguration, String fileURI, Integer expectedCount, SharedSettings sharedSettings, CompletionItem ... expectedItems) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        DOMDocument htmlDoc = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> htmlDoc);
        ContentModelSettings cmSettings = new ContentModelSettings();
        cmSettings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            cmSettings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(cmSettings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        CompletionList list = xmlLanguageService.doComplete(htmlDoc, position, sharedSettings);
        List labels = list.getItems().stream().map(i -> i.getLabel()).sorted().collect(Collectors.toList());
        String previous = null;
        for (String label : labels) {
            if (expectedCount != null) continue;
            Assertions.assertNotEquals(previous, (Object)label, () -> "Duplicate label " + label + " in " + labels.stream().collect(Collectors.joining(",")) + "}");
            previous = label;
        }
        if (expectedCount != null) {
            Assertions.assertEquals((int)expectedCount, (int)list.getItems().size());
        }
        if (expectedItems != null) {
            for (CompletionItem item : expectedItems) {
                XMLAssert.assertUnresolvedCompletion(list, item, expectedCount);
            }
        }
    }

    public static void testCompletionItemResolveFor(String value, String catalogPath, String fileURI, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionItemResolveSupportCapabilities completionItemResolveSupportCapabilities = new CompletionItemResolveSupportCapabilities();
        completionItemResolveSupportCapabilities.setProperties(Arrays.asList("documentation"));
        CompletionItemCapabilities completionItemCapabilities = new CompletionItemCapabilities();
        completionItemCapabilities.setResolveSupport(completionItemResolveSupportCapabilities);
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        completionCapabilities.setCompletionItem(completionItemCapabilities);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        XMLAssert.testCompletionItemResolveFor(new XMLLanguageService(), value, catalogPath, (XMLLanguageService _a) -> {}, fileURI, expectedCount, sharedSettings, expectedItems);
    }

    public static void testCompletionItemResolveFor(XMLLanguageService xmlLanguageService, String value, String catalogPath, Consumer<XMLLanguageService> customConfiguration, String fileURI, Integer expectedCount, SharedSettings sharedSettings, CompletionItem ... expectedItems) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        DOMDocument htmlDoc = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> htmlDoc);
        ContentModelSettings cmSettings = new ContentModelSettings();
        cmSettings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            cmSettings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(cmSettings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        CompletionList list = xmlLanguageService.doComplete(htmlDoc, position, sharedSettings);
        List labels = list.getItems().stream().map(i -> i.getLabel()).sorted().collect(Collectors.toList());
        String previous = null;
        for (String label : labels) {
            if (expectedCount != null) continue;
            Assertions.assertNotEquals(previous, (Object)label, () -> "Duplicate label " + label + " in " + labels.stream().collect(Collectors.joining(",")) + "}");
            previous = label;
        }
        if (expectedCount != null) {
            Assertions.assertEquals((int)expectedCount, (int)list.getItems().size());
        }
        CompletionList resolved = new CompletionList(list.getItems().stream().map(item -> xmlLanguageService.resolveCompletionItem(item, htmlDoc, sharedSettings, () -> {})).collect(Collectors.toList()));
        if (expectedItems != null) {
            for (CompletionItem item2 : expectedItems) {
                XMLAssert.assertCompletion(resolved, item2, expectedCount);
            }
        }
    }

    public static void assertUnresolvedCompletion(CompletionList completions, CompletionItem expected, Integer expectedCount) {
        List<CompletionItem> matches = completions.getItems().stream().filter(completion -> expected.getLabel().equals(completion.getLabel())).collect(Collectors.toList());
        if (expectedCount != null) {
            Assertions.assertTrue((matches.size() >= 1 ? 1 : 0) != 0, () -> expected.getLabel() + " should only exist once: Actual: " + completions.getItems().stream().map(c -> c.getLabel()).collect(Collectors.joining(",")));
        } else {
            Assertions.assertEquals((int)1, (int)matches.size(), () -> expected.getLabel() + " should only exist once: Actual: " + completions.getItems().stream().map(c -> c.getLabel()).collect(Collectors.joining(",")));
        }
        CompletionItem match = XMLAssert.getCompletionMatch(matches, expected);
        if (expected.getTextEdit() != null && match.getTextEdit() != null) {
            Range r;
            if (((TextEdit)expected.getTextEdit().getLeft()).getNewText() != null) {
                Assertions.assertEquals((Object)((TextEdit)expected.getTextEdit().getLeft()).getNewText(), (Object)((TextEdit)match.getTextEdit().getLeft()).getNewText());
            }
            if ((r = ((TextEdit)expected.getTextEdit().getLeft()).getRange()) != null && r.getStart() != null && r.getEnd() != null) {
                Assertions.assertEquals((Object)((TextEdit)expected.getTextEdit().getLeft()).getRange(), (Object)((TextEdit)match.getTextEdit().getLeft()).getRange());
            }
            if (expected.getAdditionalTextEdits() != null && match.getAdditionalTextEdits() != null) {
                Assertions.assertEquals((int)expected.getAdditionalTextEdits().size(), (int)match.getAdditionalTextEdits().size());
                Assertions.assertArrayEquals((Object[])expected.getAdditionalTextEdits().toArray(), (Object[])match.getAdditionalTextEdits().toArray());
            }
        }
        if (expected.getFilterText() != null && match.getFilterText() != null) {
            Assertions.assertEquals((Object)expected.getFilterText(), (Object)match.getFilterText());
        }
        if (expected.getDocumentation() != null) {
            Assertions.assertNull((Object)match.getDocumentation());
        }
    }

    public static void testDiagnosticsFor(String xml, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, expected);
    }

    public static void testDiagnosticsFor(String xml, String catalogPath, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, catalogPath, null, null, expected);
    }

    public static void testDiagnosticsFor(String xml, String catalogPath, Consumer<XMLLanguageService> configuration, String fileURI, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, catalogPath, configuration, fileURI, true, expected);
    }

    public static void testDiagnosticsFor(String xml, String catalogPath, Consumer<XMLLanguageService> configuration, String fileURI, boolean filter, Diagnostic ... expected) {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        XMLValidationRootSettings problems = new XMLValidationRootSettings();
        problems.setNoGrammar("ignore");
        settings.setValidation(problems);
        if (catalogPath != null) {
            settings.setCatalogs(new String[]{catalogPath});
        }
        XMLAssert.testDiagnosticsFor(xml, catalogPath, configuration, fileURI, filter, settings, expected);
    }

    public static void testDiagnosticsFor(String xml, String catalogPath, Consumer<XMLLanguageService> configuration, String fileURI, boolean filter, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(new XMLLanguageService(), xml, catalogPath, configuration, fileURI, filter, settings, expected);
    }

    public static void testDiagnosticsFor(XMLLanguageService xmlLanguageService, String xml, String catalogPath, Consumer<XMLLanguageService> configuration, String fileURI, boolean filter, ContentModelSettings settings, Diagnostic ... expected) {
        TextDocument document = new TextDocument(xml, fileURI != null ? fileURI : FILE_URI);
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(settings));
        if (configuration != null) {
            xmlLanguageService.initializeIfNeeded();
            configuration.accept(xmlLanguageService);
        }
        List actual = xmlLanguageService.doDiagnostics(xmlDocument, (XMLValidationSettings)settings.getValidation(), Collections.emptyMap(), () -> {});
        if (expected == null) {
            Assertions.assertTrue((boolean)actual.isEmpty());
            return;
        }
        XMLAssert.assertDiagnostics((List<Diagnostic>)actual, Arrays.asList(expected), filter);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, Diagnostic ... expected) {
        XMLAssert.assertDiagnostics(actual, Arrays.asList(expected), true);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, List<Diagnostic> expected, boolean filter) {
        List<Object> received = actual;
        boolean filterMessage = expected != null && !expected.isEmpty() && !StringUtils.isEmpty((String)expected.get(0).getMessage());
        if (filter) {
            received = actual.stream().map(d -> {
                Diagnostic simpler = new Diagnostic(d.getRange(), "");
                if (d.getCode() != null && !StringUtils.isEmpty((String)((String)d.getCode().getLeft()))) {
                    simpler.setCode(d.getCode());
                }
                if (filterMessage) {
                    simpler.setMessage(d.getMessage());
                }
                return simpler;
            }).collect(Collectors.toList());
        }
        for (Diagnostic diagnostic : received) {
            List diagnosticRelatedInformations = diagnostic.getRelatedInformation();
            if (diagnosticRelatedInformations == null) continue;
            for (DiagnosticRelatedInformation diagnosticRelatedInformation : diagnosticRelatedInformations) {
                diagnosticRelatedInformation.setMessage("");
            }
        }
        Assertions.assertIterableEquals(expected, received, (String)("Unexpected diagnostics:\n" + actual));
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, IXMLErrorCode code) {
        return XMLAssert.d(startLine, startCharacter, endLine, endCharacter, code, "");
    }

    public static Diagnostic d(int startLine, int startCharacter, int endCharacter, IXMLErrorCode code) {
        return XMLAssert.d(startLine, startCharacter, startLine, endCharacter, code);
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, IXMLErrorCode code, String message) {
        return XMLAssert.d(startLine, startCharacter, endLine, endCharacter, code, message, null, null);
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, IXMLErrorCode code, String message, String source, DiagnosticSeverity severity) {
        return new Diagnostic(XMLAssert.r(startLine, startCharacter, endLine, endCharacter), message, severity, source, code != null ? code.getCode() : null);
    }

    public static Range r(int line, int startCharacter, int endCharacter) {
        return XMLAssert.r(line, startCharacter, line, endCharacter);
    }

    public static Range r(int startLine, int startCharacter, int endLine, int endCharacter) {
        return new Range(new Position(startLine, startCharacter), new Position(endLine, endCharacter));
    }

    public static ContentModelSettings getContentModelSettings(boolean isEnabled, SchemaEnabled schemaEnabled) {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        XMLValidationRootSettings problems = new XMLValidationRootSettings();
        problems.setNoGrammar("ignore");
        settings.setValidation(problems);
        XMLValidationRootSettings diagnostics = new XMLValidationRootSettings();
        diagnostics.setEnabled(isEnabled);
        XMLSchemaSettings schemaSettings = new XMLSchemaSettings();
        schemaSettings.setEnabled(schemaEnabled);
        diagnostics.setSchema(schemaSettings);
        settings.setValidation(diagnostics);
        return settings;
    }

    public static void testPublishDiagnosticsFor(String xml, String fileURI, Consumer<XMLLanguageService> configuration, PublishDiagnosticsParams ... expected) {
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, null, configuration, expected);
    }

    public static void testPublishDiagnosticsFor(String xml, String fileURI, XMLValidationRootSettings validationSettings, PublishDiagnosticsParams ... expected) {
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validationSettings, (Consumer<XMLLanguageService>)null, expected);
    }

    public static void testPublishDiagnosticsFor(String xml, String fileURI, XMLValidationRootSettings validationSettings, Consumer<XMLLanguageService> configuration, PublishDiagnosticsParams ... expected) {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        if (configuration != null) {
            xmlLanguageService.initializeIfNeeded();
            configuration.accept(xmlLanguageService);
        }
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validationSettings, xmlLanguageService, expected);
    }

    public static void testPublishDiagnosticsFor(String xml, String fileURI, XMLLanguageService xmlLanguageService, PublishDiagnosticsParams ... expected) {
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, null, xmlLanguageService, expected);
    }

    public static void testPublishDiagnosticsFor(String xml, String fileURI, XMLValidationRootSettings validationSettings, XMLLanguageService xmlLanguageService, PublishDiagnosticsParams ... expected) {
        ArrayList<PublishDiagnosticsParams> actual = new ArrayList<PublishDiagnosticsParams>();
        DOMDocument xmlDocument = DOMParser.getInstance().parse(xml, fileURI, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        XMLAssert.publishDiagnostics(xmlDocument, validationSettings, actual, xmlLanguageService);
        XMLAssert.assertPublishDiagnostics(actual, expected);
    }

    public static void assertPublishDiagnostics(List<PublishDiagnosticsParams> actual, PublishDiagnosticsParams ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i].getUri(), (Object)actual.get(i).getUri());
            actual.get(i).getDiagnostics().forEach(d -> d.setMessage(cleanExceptionMessage.apply(d.getMessage())));
            expected[i].getDiagnostics().forEach(d -> d.setMessage(cleanExceptionMessage.apply(d.getMessage())));
            XMLAssert.assertDiagnostics((List<Diagnostic>)actual.get(i).getDiagnostics(), expected[i].getDiagnostics(), false);
        }
    }

    public static void publishDiagnostics(DOMDocument xmlDocument, List<PublishDiagnosticsParams> actual, XMLLanguageService languageService) {
        XMLAssert.publishDiagnostics(xmlDocument, null, actual, languageService);
    }

    public static void publishDiagnostics(DOMDocument xmlDocument, XMLValidationRootSettings validationSettings, List<PublishDiagnosticsParams> actual, XMLLanguageService languageService) {
        CompletableFuture error = languageService.publishDiagnostics(xmlDocument, params -> actual.add((PublishDiagnosticsParams)params), doc -> XMLAssert.publishDiagnostics(xmlDocument, actual, languageService), validationSettings, Collections.emptyMap(), () -> {});
        if (error != null) {
            try {
                error.join();
                Thread.sleep(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static PublishDiagnosticsParams pd(String uri, Diagnostic ... diagnostics) {
        return new PublishDiagnosticsParams(uri, Arrays.asList(diagnostics));
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, diagnostic, (String)null, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, int index, CodeAction ... expected) throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        return XMLAssert.testCodeActionsFor(xml, diagnostic, null, null, null, settings, null, index, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, String fileURI, Diagnostic diagnostic, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, fileURI, diagnostic, (String)null, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, SharedSettings settings, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, diagnostic, null, settings, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, String catalogPath, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, null, diagnostic, catalogPath, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, String fileURI, Diagnostic diagnostic, String catalogPath, CodeAction ... expected) throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        return XMLAssert.testCodeActionsFor(xml, diagnostic, null, catalogPath, fileURI, settings, null, -1, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, String catalogPath, SharedSettings sharedSettings, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, diagnostic, catalogPath, sharedSettings, null, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, String catalogPath, SharedSettings sharedSettings, XMLLanguageService xmlLanguageService, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, diagnostic, null, catalogPath, null, sharedSettings, xmlLanguageService, -1, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Range range, String catalogPath, SharedSettings sharedSettings, XMLLanguageService xmlLanguageService, CodeAction ... expected) throws BadLocationException {
        return XMLAssert.testCodeActionsFor(xml, null, range, catalogPath, null, sharedSettings, xmlLanguageService, -1, expected);
    }

    public static List<CodeAction> testCodeActionsFor(String xml, Diagnostic diagnostic, Range range, String catalogPath, String fileURI, SharedSettings sharedSettings, XMLLanguageService xmlLanguageService, int index, CodeAction ... expected) throws BadLocationException {
        int offset = xml.indexOf(124);
        if (offset != -1) {
            xml = xml.substring(0, offset) + xml.substring(offset + 1);
        }
        TextDocument document = new TextDocument(xml.toString(), fileURI != null ? fileURI : FILE_URI);
        if (offset != -1) {
            Position position = document.positionAt(offset);
            range = new Range(position, position);
        } else if (range == null && diagnostic != null) {
            range = diagnostic.getRange();
        }
        Assertions.assertNotNull((Object)range, (String)"Range cannot be null");
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        ContentModelSettings cmSettings = new ContentModelSettings();
        cmSettings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            cmSettings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(cmSettings));
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(Arrays.asList(diagnostic));
        DOMDocument xmlDoc = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDoc);
        List actual = xmlLanguageService.doCodeActions(context, range, xmlDoc, sharedSettings, () -> {});
        Gson gson = new Gson();
        String jsonstring = gson.toJson((Object)actual);
        CodeAction[] cloned_list = (CodeAction[])gson.fromJson(jsonstring, CodeAction[].class);
        if (index >= 0) {
            XMLAssert.assertCodeActions(Arrays.asList((CodeAction)actual.get(index)), Arrays.asList(expected).get(index));
            return Arrays.asList(cloned_list);
        }
        XMLAssert.assertCodeActions(actual, expected);
        return Arrays.asList(cloned_list);
    }

    public static void assertCodeActions(List<CodeAction> actual, CodeAction ... expected) {
        actual.stream().forEach(ca -> {
            ca.setKind(null);
            ca.setTitle("");
            if (ca.getDiagnostics() != null) {
                ca.getDiagnostics().forEach(d -> {
                    if (d != null) {
                        d.setSeverity(null);
                        d.setMessage("");
                        d.setSource(null);
                    }
                });
            }
        });
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static CodeAction ca(Diagnostic d, TextEdit ... te) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle("");
        codeAction.setDiagnostics(Arrays.asList(d));
        TextDocumentEdit textDocumentEdit = XMLAssert.tde(FILE_URI, 0, te);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        codeAction.setEdit(workspaceEdit);
        return codeAction;
    }

    public static CodeAction ca(Diagnostic d) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle("");
        codeAction.setDiagnostics(Arrays.asList(d));
        return codeAction;
    }

    public static CodeAction ca(Diagnostic d, Command c) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle("");
        codeAction.setDiagnostics(Arrays.asList(d));
        codeAction.setCommand(c);
        return codeAction;
    }

    public static CodeAction ca(Diagnostic d, JsonObject data) {
        return XMLAssert.internalCa(d, data, new Either[0]);
    }

    @SafeVarargs
    public static CodeAction ca(Diagnostic d, Either<TextDocumentEdit, ResourceOperation> ... ops) {
        return XMLAssert.internalCa(d, null, ops);
    }

    @SafeVarargs
    public static CodeAction ca(Diagnostic d, JsonObject data, Either<TextDocumentEdit, ResourceOperation> ... ops) {
        return XMLAssert.internalCa(d, data, ops);
    }

    @SafeVarargs
    private static CodeAction internalCa(Diagnostic d, JsonObject data, Either<TextDocumentEdit, ResourceOperation> ... ops) {
        CodeAction codeAction = new CodeAction();
        codeAction.setDiagnostics(Collections.singletonList(d));
        if (ops != null && ops.length > 0) {
            codeAction.setEdit(new WorkspaceEdit(Arrays.asList(ops)));
        }
        codeAction.setTitle("");
        codeAction.setData((Object)data);
        return codeAction;
    }

    public static void testResolveCodeActionsFor(String xml, CodeAction unresolved, SharedSettings sharedSettings, CodeAction expected) throws BadLocationException {
        XMLAssert.testResolveCodeActionsFor(xml, unresolved, null, null, sharedSettings, null, expected);
    }

    public static void testResolveCodeActionsFor(String xml, CodeAction unresolved, SharedSettings sharedSettings, XMLLanguageService xmlLanguageService, CodeAction expected) throws BadLocationException {
        XMLAssert.testResolveCodeActionsFor(xml, unresolved, null, null, sharedSettings, xmlLanguageService, expected);
    }

    public static void testResolveCodeActionsFor(String xml, CodeAction unresolved, String catalogPath, String fileURI, SharedSettings sharedSettings, XMLLanguageService xmlLanguageService, CodeAction expected) throws BadLocationException {
        TextDocument document = new TextDocument(xml.toString(), fileURI != null ? fileURI : FILE_URI);
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        ContentModelSettings cmSettings = new ContentModelSettings();
        cmSettings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            cmSettings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(cmSettings));
        DOMDocument xmlDoc = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        CodeAction actual = xmlLanguageService.resolveCodeAction(unresolved, xmlDoc, sharedSettings, () -> {});
        if (expected == null) {
            Assertions.assertNull((Object)actual);
        } else {
            XMLAssert.assertCodeActions(Arrays.asList(actual), expected);
        }
    }

    public static TextDocumentEdit tde(String uri, int version, TextEdit ... te) {
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(version));
        return new TextDocumentEdit(versionedTextDocumentIdentifier, Arrays.asList(te));
    }

    public static TextEdit te(int startLine, int startCharacter, int endLine, int endCharacter, String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(newText);
        textEdit.setRange(XMLAssert.r(startLine, startCharacter, endLine, endCharacter));
        return textEdit;
    }

    public static Either<TextDocumentEdit, ResourceOperation> createFile(String uri, boolean overwrite) {
        CreateFileOptions options = new CreateFileOptions();
        options.setIgnoreIfExists(Boolean.valueOf(!overwrite));
        options.setOverwrite(Boolean.valueOf(overwrite));
        return Either.forRight((Object)new CreateFile(uri, options));
    }

    public static Either<TextDocumentEdit, ResourceOperation> teOp(String uri, int startLine, int startChar, int endLine, int endChar, String newText) {
        return Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0)), Collections.singletonList(XMLAssert.te(startLine, startChar, endLine, endChar, newText))));
    }

    public static Either<TextDocumentEdit, ResourceOperation> teOp(String uri, TextEdit ... te) {
        return Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0)), Arrays.asList(te)));
    }

    public static void assertHover(String value) throws BadLocationException {
        XMLAssert.assertHover(value, null, null);
    }

    public static void assertHover(String value, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        XMLAssert.assertHover(value, null, expectedHoverLabel, expectedHoverRange);
    }

    public static void assertHover(String value, String fileURI, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        XMLAssert.assertHover(new XMLLanguageService(), value, null, fileURI, expectedHoverLabel, expectedHoverRange);
    }

    public static void assertHover(XMLLanguageService xmlLanguageService, String value, String catalogPath, String fileURI, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        XMLAssert.assertHover(xmlLanguageService, value, catalogPath, fileURI, expectedHoverLabel, expectedHoverRange, settings);
    }

    public static void assertHover(XMLLanguageService xmlLanguageService, String value, String catalogPath, String fileURI, String expectedHoverLabel, Range expectedHoverRange, SharedSettings sharedSettings) throws BadLocationException {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        XMLAssert.assertHover(xmlLanguageService, value, catalogPath, fileURI, expectedHoverLabel, expectedHoverRange, settings, sharedSettings);
    }

    public static void assertHover(XMLLanguageService xmlLanguageService, String value, String catalogPath, String fileURI, String expectedHoverLabel, Range expectedHoverRange, ContentModelSettings settings) throws BadLocationException {
        SharedSettings sharedSettings = new SharedSettings();
        HoverCapabilities capabilities = new HoverCapabilities(Arrays.asList("markdown"), Boolean.valueOf(false));
        sharedSettings.getHoverSettings().setCapabilities(capabilities);
        XMLAssert.assertHover(xmlLanguageService, value, catalogPath, fileURI, expectedHoverLabel, expectedHoverRange, settings, sharedSettings);
    }

    public static void assertHover(XMLLanguageService xmlLanguageService, String value, String catalogPath, String fileURI, String expectedHoverLabel, Range expectedHoverRange, ContentModelSettings settings, SharedSettings sharedSettings) throws BadLocationException {
        int offset = value.indexOf("|");
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.html");
        Position position = document.positionAt(offset);
        DOMDocument htmlDoc = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        if (catalogPath != null) {
            settings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(settings));
        Hover hover = xmlLanguageService.doHover(htmlDoc, position, sharedSettings);
        if (expectedHoverLabel == null) {
            Assertions.assertNull((Object)hover);
        } else {
            String actualHoverLabel = XMLAssert.getHoverLabel(hover);
            Assertions.assertEquals((Object)expectedHoverLabel, (Object)actualHoverLabel);
            if (expectedHoverRange != null) {
                Assertions.assertEquals((Object)expectedHoverRange, (Object)hover.getRange());
            }
        }
    }

    private static String getHoverLabel(Hover hover) {
        Either contents;
        Either either = contents = hover != null ? hover.getContents() : null;
        if (contents == null) {
            return null;
        }
        return ((MarkupContent)contents.getRight()).getValue();
    }

    public static void testDocumentLinkFor(String xml, String fileURI, DocumentLink ... expected) {
        XMLAssert.testDocumentLinkFor(xml, fileURI, null, expected);
    }

    public static void testDocumentLinkFor(String xml, String fileURI, String catalogPath, DocumentLink ... expected) {
        XMLAssert.testDocumentLinkFor(null, xml, fileURI, catalogPath, expected);
    }

    public static void testDocumentLinkFor(XMLLanguageService xmlLanguageService, String xml, String fileURI, String catalogPath, DocumentLink ... expected) {
        TextDocument document = new TextDocument(xml, fileURI != null ? fileURI : FILE_URI);
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            settings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(settings));
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findDocumentLinks(xmlDocument);
        XMLAssert.assertDocumentLinks(actual, expected);
    }

    public static DocumentLink dl(Range range, String target) {
        return new DocumentLink(range, target);
    }

    public static void assertDocumentLinks(List<DocumentLink> actual, DocumentLink ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i].getRange(), (Object)actual.get(i).getRange(), (String)(" Range test '" + i + "' link"));
            Assertions.assertEquals((Object)Paths.get(expected[i].getTarget(), new String[0]).toUri().toString().replace("file:///", "file:/"), (Object)actual.get(i).getTarget().replace("file:///", "file:/"), (String)(" Target test '" + i + "' link"));
        }
    }

    public static void testDocumentSymbolsFor(String xml, DocumentSymbol ... expected) {
        XMLAssert.testDocumentSymbolsFor(xml, null, new XMLSymbolSettings(), expected);
    }

    public static void testDocumentSymbolsFor(String xml, XMLSymbolSettings symbolSettings, DocumentSymbol ... expected) {
        XMLAssert.testDocumentSymbolsFor(xml, null, symbolSettings, expected);
    }

    public static void testDocumentSymbolsFor(String xml, String fileURI, DocumentSymbol ... expected) {
        XMLAssert.testDocumentSymbolsFor(xml, fileURI, new XMLSymbolSettings(), expected);
    }

    public static void testDocumentSymbolsFor(String xml, String fileURI, XMLSymbolSettings symbolSettings, DocumentSymbol ... expected) {
        XMLAssert.testDocumentSymbolsFor(xml, fileURI, symbolSettings, null, expected);
    }

    public static void testDocumentSymbolsFor(String xml, String fileURI, XMLSymbolSettings symbolSettings, Consumer<XMLLanguageService> customConfiguration, DocumentSymbol ... expected) {
        XMLAssert.testDocumentSymbolsFor(new XMLLanguageService(), xml, fileURI, symbolSettings, customConfiguration, expected);
    }

    public static void testDocumentSymbolsFor(XMLLanguageService xmlLanguageService, String xml, String fileURI, XMLSymbolSettings symbolSettings, Consumer<XMLLanguageService> customConfiguration, DocumentSymbol ... expected) {
        TextDocument document = new TextDocument(xml, fileURI != null ? fileURI : FILE_URI);
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(settings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findDocumentSymbols(xmlDocument, symbolSettings);
        XMLAssert.assertDocumentSymbols(actual, expected);
    }

    public static DocumentSymbol ds(String name, SymbolKind kind, Range range, Range selectionRange, String detail, List<DocumentSymbol> children) {
        return new DocumentSymbol(name, kind, range, selectionRange, detail, children);
    }

    public static void assertDocumentSymbols(List<DocumentSymbol> actual, DocumentSymbol ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testSymbolInformationsFor(String xml, SymbolInformation ... expected) {
        XMLAssert.testSymbolInformationsFor(xml, null, new XMLSymbolSettings(), expected);
    }

    public static void testSymbolInformationsFor(String xml, XMLSymbolSettings symbolSettings, SymbolInformation ... expected) {
        XMLAssert.testSymbolInformationsFor(xml, null, symbolSettings, expected);
    }

    public static void testSymbolInformationsFor(String xml, String fileURI, SymbolInformation ... expected) {
        XMLAssert.testSymbolInformationsFor(xml, fileURI, new XMLSymbolSettings(), expected);
    }

    public static void testSymbolInformationsFor(String xml, String fileURI, XMLSymbolSettings symbolSettings, SymbolInformation ... expected) {
        XMLAssert.testSymbolInformationsFor(xml, fileURI, symbolSettings, null, expected);
    }

    public static void testSymbolInformationsFor(String xml, String fileURI, XMLSymbolSettings symbolSettings, Consumer<XMLLanguageService> customConfiguration, SymbolInformation ... expected) {
        XMLAssert.testSymbolInformationsFor(new XMLLanguageService(), xml, fileURI, symbolSettings, customConfiguration, expected);
    }

    public static void testSymbolInformationsFor(XMLLanguageService xmlLanguageService, String xml, String fileURI, XMLSymbolSettings symbolSettings, Consumer<XMLLanguageService> customConfiguration, SymbolInformation ... expected) {
        TextDocument document = new TextDocument(xml, fileURI != null ? fileURI : FILE_URI);
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(settings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findSymbolInformations(xmlDocument, symbolSettings);
        XMLAssert.assertSymbolInformations(actual, expected);
    }

    public static SymbolInformation si(String name, SymbolKind kind, Location location, String containerName) {
        return new SymbolInformation(name, kind, location, containerName);
    }

    public static void assertSymbolInformations(List<SymbolInformation> actual, SymbolInformation ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testDefinitionFor(String xml, LocationLink ... expected) throws BadLocationException {
        XMLAssert.testDefinitionFor(xml, null, expected);
    }

    public static void testDefinitionFor(String value, String fileURI, LocationLink ... expected) throws BadLocationException {
        XMLAssert.testDefinitionFor(null, value, fileURI, expected);
    }

    public static void testDefinitionFor(XMLLanguageService xmlLanguageService, String value, String fileURI, LocationLink ... expected) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findDefinition(xmlDocument, position, () -> {});
        XMLAssert.assertLocationLink(actual, expected);
    }

    public static LocationLink ll(String uri, Range originRange, Range targetRange) {
        return new LocationLink(uri, targetRange, targetRange, originRange);
    }

    public static void assertLocationLink(List<? extends LocationLink> actual, LocationLink ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            actual.get(i).setTargetUri(actual.get(i).getTargetUri().replace("file:///", "file:/"));
            expected[i].setTargetUri(expected[i].getTargetUri().replace("file:///", "file:/"));
        }
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testTypeDefinitionFor(XMLLanguageService xmlLanguageService, String value, String fileURI, LocationLink ... expected) throws BadLocationException {
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, null, value, fileURI, expected);
    }

    public static void testTypeDefinitionFor(XMLLanguageService xmlLanguageService, String catalogPath, String value, String fileURI, LocationLink ... expected) throws BadLocationException {
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, catalogPath, null, value, fileURI, expected);
    }

    public static void testTypeDefinitionFor(XMLLanguageService xmlLanguageService, String catalogPath, Consumer<XMLLanguageService> customConfiguration, String value, String fileURI, LocationLink ... expected) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        ContentModelSettings cmSettings = new ContentModelSettings();
        cmSettings.setUseCache(Boolean.valueOf(false));
        if (catalogPath != null) {
            cmSettings.setCatalogs(new String[]{catalogPath});
        }
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(cmSettings));
        xmlLanguageService.initializeIfNeeded();
        if (customConfiguration != null) {
            customConfiguration.accept(xmlLanguageService);
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findTypeDefinition(xmlDocument, position, () -> {});
        XMLAssert.assertLocationLink(actual, expected);
    }

    public static void testReferencesFor(String xml, Location ... expected) throws BadLocationException {
        XMLAssert.testReferencesFor(xml, null, expected);
    }

    public static void testReferencesFor(String value, String fileURI, Location ... expected) throws BadLocationException {
        XMLAssert.testReferencesFor(null, value, fileURI, expected);
    }

    public static void testReferencesFor(XMLLanguageService xmlLanguageService, String value, String fileURI, Location ... expected) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findReferences(xmlDocument, position, new ReferenceContext(), () -> {});
        XMLAssert.assertLocation(actual, expected);
    }

    public static Location l(String uri, Range range) {
        return new Location(uri, range);
    }

    public static void assertLocation(List<? extends Location> actual, Location ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static void testCodeLensFor(String xml, CodeLens ... expected) throws BadLocationException {
        XMLAssert.testCodeLensFor(xml, null, expected);
    }

    public static void testCodeLensFor(String value, String fileURI, CodeLens ... expected) throws BadLocationException {
        XMLAssert.testCodeLensFor(value, fileURI, new XMLLanguageService(), expected);
    }

    public static void testCodeLensFor(String value, String fileURI, XMLLanguageService xmlLanguageService, CodeLens ... expected) {
        XMLAssert.testCodeLensFor(value, fileURI, xmlLanguageService, Arrays.asList("references", "association", "open.uri"), expected);
    }

    public static void testCodeLensFor(String value, String fileURI, List<String> codelensKinds, CodeLens ... expected) {
        XMLAssert.testCodeLensFor(value, fileURI, new XMLLanguageService(), codelensKinds, expected);
    }

    public static void testCodeLensFor(String value, String fileURI, XMLLanguageService xmlLanguageService, List<String> codelensKinds, CodeLens ... expected) {
        XMLAssert.testCodeLensFor(value, fileURI, xmlLanguageService, codelensKinds, null, expected);
    }

    public static void testCodeLensFor(String value, String fileURI, XMLLanguageService xmlLanguageService, List<String> codelensKinds, Consumer<XMLLanguageService> customConfiguration, CodeLens ... expected) {
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(false));
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(settings));
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        if (customConfiguration != null) {
            xmlLanguageService.initializeIfNeeded();
            customConfiguration.accept(xmlLanguageService);
        }
        XMLCodeLensSettings codeLensSettings = new XMLCodeLensSettings();
        ExtendedCodeLensCapabilities codeLensCapabilities = new ExtendedCodeLensCapabilities(new CodeLensKindCapabilities(codelensKinds));
        codeLensSettings.setCodeLens(codeLensCapabilities);
        List actual = xmlLanguageService.getCodeLens(xmlDocument, codeLensSettings, () -> {});
        XMLAssert.assertCodeLens(actual, expected);
    }

    public static CodeLens cl(Range range, String title, String command) {
        return new CodeLens(range, new Command(title, command), null);
    }

    public static void assertCodeLens(List<? extends CodeLens> actual, CodeLens ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i].getRange(), (Object)actual.get(i).getRange());
            Command expectedCommand = expected[i].getCommand();
            Command actualCommand = actual.get(i).getCommand();
            if (expectedCommand != null && actualCommand != null) {
                Assertions.assertEquals((Object)expectedCommand.getTitle(), (Object)actualCommand.getTitle());
                Assertions.assertEquals((Object)expectedCommand.getCommand(), (Object)actualCommand.getCommand());
            }
            Assertions.assertEquals((Object)expected[i].getData(), (Object)actual.get(i).getData());
        }
    }

    public static void testHighlightsFor(String xml, DocumentHighlight ... expected) throws BadLocationException {
        XMLAssert.testHighlightsFor(xml, null, expected);
    }

    public static void testHighlightsFor(String value, String fileURI, DocumentHighlight ... expected) throws BadLocationException {
        XMLAssert.testHighlightsFor(new XMLLanguageService(), value, fileURI, expected);
    }

    public static void testHighlightsFor(XMLLanguageService xmlLanguageService, String value, String fileURI, DocumentHighlight ... expected) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        if (xmlLanguageService == null) {
            xmlLanguageService = new XMLLanguageService();
        }
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findDocumentHighlights(xmlDocument, position, () -> {});
        XMLAssert.assertDocumentHighlight(actual, expected);
    }

    public static void assertDocumentHighlight(List<? extends DocumentHighlight> actual, DocumentHighlight ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual.toArray());
    }

    public static DocumentHighlight hl(Range range) {
        return XMLAssert.hl(range, DocumentHighlightKind.Read);
    }

    public static DocumentHighlight hl(Range range, DocumentHighlightKind kind) {
        return new DocumentHighlight(range, kind);
    }

    public static void assertHighlights(String value, int[] expectedMatches, String elementName) throws BadLocationException {
        XMLAssert.assertHighlights(null, value, expectedMatches, elementName);
    }

    public static void assertHighlights(XMLLanguageService languageService, String value, int[] expectedMatches, String elementName) throws BadLocationException {
        int offset = value.indexOf("|");
        value = value.substring(0, offset) + value.substring(offset + 1);
        DOMDocument document = DOMParser.getInstance().parse(value, "test://test/test.html", null);
        Position position = document.positionAt(offset);
        if (languageService == null) {
            languageService = new XMLLanguageService();
        }
        List highlights = languageService.findDocumentHighlights(document, position);
        Assertions.assertEquals((int)expectedMatches.length, (int)highlights.size());
        for (int i = 0; i < highlights.size(); ++i) {
            DocumentHighlight highlight = (DocumentHighlight)highlights.get(i);
            int actualStartOffset = document.offsetAt(highlight.getRange().getStart());
            Assertions.assertEquals((int)expectedMatches[i], (int)actualStartOffset);
            int actualEndOffset = document.offsetAt(highlight.getRange().getEnd());
            Assertions.assertEquals((int)(expectedMatches[i] + (elementName != null ? elementName.length() : 0)), (int)actualEndOffset);
            Assertions.assertEquals((Object)elementName, (Object)document.getText().substring(actualStartOffset, actualEndOffset).toLowerCase());
        }
    }

    public static void assertFormat(String unformatted, String actual) throws BadLocationException {
        XMLAssert.assertFormat(unformatted, actual, new SharedSettings());
    }

    public static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings) throws BadLocationException {
        XMLAssert.assertFormat(unformatted, expected, sharedSettings, "test://test.html");
    }

    public static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri) throws BadLocationException {
        XMLAssert.assertFormat(unformatted, expected, sharedSettings, uri, true);
    }

    public static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat);
    }

    public static void assertFormat(XMLLanguageService languageService, String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat) throws BadLocationException {
        XMLAssert.assertFormat(languageService, unformatted, expected, sharedSettings, uri, considerRangeFormat, null);
    }

    public static void assertFormat(XMLLanguageService languageService, String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        int rangeEnd;
        Range range = null;
        int rangeStart = considerRangeFormat != false ? unformatted.indexOf(124) : -1;
        int n = rangeEnd = considerRangeFormat != false ? unformatted.lastIndexOf(124) : -1;
        if (rangeStart != -1 && rangeEnd != -1) {
            unformatted = unformatted.substring(0, rangeStart) + unformatted.substring(rangeStart + 1, rangeEnd) + unformatted.substring(rangeEnd + 1);
            DOMDocument unformattedDoc = DOMParser.getInstance().parse(unformatted, uri, null);
            Position startPos = unformattedDoc.positionAt(rangeStart);
            Position endPos = unformattedDoc.positionAt(rangeEnd - 1);
            range = new Range(startPos, endPos);
        }
        TextDocument document = new TextDocument(unformatted, uri);
        document.setIncremental(true);
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, null);
        if (languageService == null) {
            languageService = new XMLLanguageService();
        }
        List edits = languageService.format(xmlDocument, range, sharedSettings);
        String formatted = TextEditUtils.applyEdits((TextDocument)document, (List)edits);
        Assertions.assertEquals((Object)expected, (Object)formatted);
        if (expectedEdits != null) {
            Assertions.assertArrayEquals((Object[])expectedEdits, (Object[])edits.toArray(new TextEdit[0]));
        }
    }

    public static PrepareRenameResult pr(Range range, String placeholder) {
        return new PrepareRenameResult(range, placeholder);
    }

    public static void assertPrepareRename(String value) throws BadLocationException {
        XMLAssert.assertRename(value, null);
    }

    public static void assertPrepareRename(String value, PrepareRenameResult expected) throws BadLocationException {
        XMLAssert.assertPrepareRename(null, value, expected);
    }

    public static void assertPrepareRename(XMLLanguageService languageService, String value, PrepareRenameResult expected) throws BadLocationException {
        XMLAssert.assertPrepareRename(languageService, value, null, expected);
    }

    public static void assertPrepareRename(XMLLanguageService languageService, String value, String fileURI, PrepareRenameResult expected) throws BadLocationException {
        Either result;
        int offset = value.indexOf("|");
        value = value.substring(0, offset) + value.substring(offset + 1);
        fileURI = fileURI != null ? fileURI : "test://test/test.html";
        DOMDocument document = DOMParser.getInstance().parse(value, fileURI, null);
        Position position = document.positionAt(offset);
        if (languageService == null) {
            languageService = new XMLLanguageService();
        }
        PrepareRenameResult actual = (result = languageService.prepareRename(document, position, () -> {})) != null ? (PrepareRenameResult)result.getRight() : null;
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertRename(String value, String newText) throws BadLocationException {
        XMLAssert.assertRename(value, newText, Collections.emptyList());
    }

    public static void assertRename(String value, String newText, List<TextEdit> expectedEdits) throws BadLocationException {
        XMLAssert.assertRename(null, value, newText, expectedEdits);
    }

    public static void assertRename(XMLLanguageService languageService, String value, String newText, List<TextEdit> expectedEdits) throws BadLocationException {
        XMLAssert.assertRename(languageService, value, null, newText, expectedEdits);
    }

    public static void assertRename(XMLLanguageService languageService, String value, String fileURI, String newText, List<TextEdit> expectedEdits) throws BadLocationException {
        int offset = value.indexOf("|");
        value = value.substring(0, offset) + value.substring(offset + 1);
        fileURI = fileURI != null ? fileURI : "test://test/test.html";
        DOMDocument document = DOMParser.getInstance().parse(value, fileURI, null);
        Position position = document.positionAt(offset);
        if (languageService == null) {
            languageService = new XMLLanguageService();
        }
        WorkspaceEdit workspaceEdit = languageService.doRename(document, position, newText, () -> {});
        String uri = fileURI;
        Optional<TextDocumentEdit> documentChange = workspaceEdit.getDocumentChanges().stream().filter(Either::isLeft).filter(e -> uri.equals(((TextDocumentEdit)e.getLeft()).getTextDocument().getUri())).map(Either::getLeft).findFirst();
        List actualEdits = documentChange.isPresent() ? documentChange.get().getEdits() : Collections.emptyList();
        Assertions.assertArrayEquals((Object[])expectedEdits.toArray(), (Object[])actualEdits.toArray());
    }

    public static void testLinkedEditingFor(String xml, LinkedEditingRanges expected) throws BadLocationException {
        XMLAssert.testLinkedEditingFor(xml, null, expected);
    }

    public static void testLinkedEditingFor(String value, String fileURI, LinkedEditingRanges expected) throws BadLocationException {
        XMLAssert.testLinkedEditingFor(new XMLLanguageService(), value, fileURI, expected);
    }

    public static void testLinkedEditingFor(XMLLanguageService xmlLanguageService, String value, String fileURI, LinkedEditingRanges expected) throws BadLocationException {
        int offset = value.indexOf(124);
        value = value.substring(0, offset) + value.substring(offset + 1);
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        Position position = document.positionAt(offset);
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        LinkedEditingRanges actual = xmlLanguageService.findLinkedEditingRanges(xmlDocument, position, () -> {});
        XMLAssert.assertLinkedEditing(actual, expected);
    }

    public static void assertLinkedEditing(LinkedEditingRanges actual, LinkedEditingRanges expected) {
        if (expected == null) {
            Assertions.assertNull((Object)actual);
        } else {
            Assertions.assertNotNull((Object)actual);
            Assertions.assertEquals((Object)expected.getWordPattern(), (Object)actual.getWordPattern());
            Assertions.assertEquals((Object)expected.getRanges(), (Object)actual.getRanges());
        }
    }

    public static LinkedEditingRanges le(Range ... ranges) {
        return new LinkedEditingRanges(Arrays.asList(ranges), "[^\\s>]+");
    }

    public static LinkedEditingRanges le(String wordPattern, Range ... ranges) {
        return new LinkedEditingRanges(Arrays.asList(ranges), wordPattern);
    }

    public static void assertGrammarGenerator(String xml, FileContentGeneratorSettings grammarSettings, String expected) {
        XMLAssert.assertGrammarGenerator(xml, grammarSettings, new SharedSettings(), expected);
    }

    public static void assertGrammarGenerator(String xml, FileContentGeneratorSettings grammarSettings, SharedSettings sharedSettings, String expected) {
        DOMDocument document = DOMParser.getInstance().parse(xml, FILE_URI, null);
        XMLLanguageService languageService = new XMLLanguageService();
        FileContentGeneratorManager manager = new FileContentGeneratorManager((IXMLFullFormatter)languageService);
        String actual = manager.generate((Object)document, sharedSettings, grammarSettings, () -> {});
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static void testSelectionRange(String xml, SelectionRange ... selectionRanges) {
        StringBuilder stringBuilder = new StringBuilder(xml);
        ArrayList<Integer> cursorOffsets = new ArrayList<Integer>();
        int nextPipe = stringBuilder.indexOf("|");
        while (nextPipe > 0) {
            cursorOffsets.add(nextPipe);
            stringBuilder.deleteCharAt(nextPipe);
            nextPipe = stringBuilder.indexOf("|");
        }
        Assertions.assertEquals((int)selectionRanges.length, (int)cursorOffsets.size(), (String)"Number of cursors and SelectionRanges should be equal");
        XMLAssert.testSelectionRange(stringBuilder.toString(), cursorOffsets, selectionRanges);
    }

    public static void testSelectionRange(String xml, List<Integer> cursorOffsets, SelectionRange ... selectionRanges) {
        DOMDocument document = DOMParser.getInstance().parse(xml, "test://test/test.html", null);
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Integer offset : cursorOffsets) {
            positions.add(XMLPositionUtility.createRange((int)offset, (int)offset, (DOMDocument)document).getStart());
        }
        XMLLanguageService ls = new XMLLanguageService();
        List actual = ls.getSelectionRanges(document, positions, NULL_CHECKER);
        XMLAssert.assertSelectionRangeEquals(Arrays.asList(selectionRanges), actual);
    }

    public static void assertSelectionRangeEquals(List<SelectionRange> expected, List<SelectionRange> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Different number of expected and actual selection ranges");
        for (int i = 0; i < expected.size(); ++i) {
            Assertions.assertEquals((Object)expected.get(i), (Object)actual.get(i));
        }
    }

    public static SelectionRange sr(Range ... ranges) {
        return XMLAssert.sr(Arrays.asList(ranges));
    }

    public static SelectionRange sr(List<Range> ranges) {
        if (ranges.size() == 0) {
            return null;
        }
        SelectionRange selectionRange = new SelectionRange();
        selectionRange.setRange(ranges.get(0));
        selectionRange.setParent(XMLAssert.sr(ranges.subList(1, ranges.size())));
        return selectionRange;
    }

    public static void assertSurroundWith(String xml, SurroundWithCommand.SurroundWithKind kind, boolean snippetsSupported, String expected) throws BadLocationException, InterruptedException, ExecutionException {
        XMLAssert.assertSurroundWith(xml, kind, snippetsSupported, service -> {}, "src/test/resources/test.xml", expected);
    }

    public static void assertSurroundWith(String xml, SurroundWithCommand.SurroundWithKind kind, boolean snippetsSupported, Consumer<XMLLanguageService> configuration, String uri, String expected) throws BadLocationException, InterruptedException, ExecutionException {
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        configuration.accept(languageServer.getXMLLanguageService());
        int rangeStart = xml.indexOf(124);
        int rangeEnd = xml.lastIndexOf(124);
        StringBuilder x = new StringBuilder(xml.substring(0, rangeStart));
        if (rangeEnd > rangeStart) {
            x.append(xml.substring(rangeStart + 1, rangeEnd));
        }
        x.append(xml.substring(Math.min(rangeEnd + 1, xml.length())));
        TextDocument document = new TextDocument(x.toString(), "");
        Position startPos = document.positionAt(rangeStart);
        Position endPos = rangeStart == rangeEnd ? startPos : document.positionAt(rangeEnd - 1);
        Range selection = new Range(startPos, endPos);
        TextDocumentIdentifier xmlIdentifier = languageServer.didOpen(uri, x.toString());
        SurroundWithCommand.SurroundWithResponse response = (SurroundWithCommand.SurroundWithResponse)languageServer.executeCommand("xml.refactor.surround.with", xmlIdentifier, selection, kind.name(), snippetsSupported).get();
        String actual = TextEditUtils.applyEdits((TextDocument)document, Arrays.asList(response.getStart(), response.getEnd()));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static void testColorInformationFor(String value, String fileURI, XMLColorsSettings colorSettings, ColorInformation ... expected) {
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(colorSettings));
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        List actual = xmlLanguageService.findDocumentColors(xmlDocument, () -> {});
        XMLAssert.assertColorInformation(actual, expected);
    }

    public static ColorInformation colorInfo(double red, double green, double blue, double alpha, Range range) {
        return new ColorInformation(range, new Color(red, green, blue, alpha));
    }

    public static void assertColorInformation(List<? extends ColorInformation> actual, ColorInformation ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i].getRange(), (Object)actual.get(i).getRange());
            Assertions.assertEquals((Object)expected[i].getColor(), (Object)actual.get(i).getColor());
        }
    }

    public static void testColorPresentationFor(String value, String fileURI, Color color, Range range, XMLColorsSettings colorSettings, ColorPresentation ... expected) {
        TextDocument document = new TextDocument(value, fileURI != null ? fileURI : "test://test/test.xml");
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        xmlLanguageService.doSave((ISaveContext)new SettingsSaveContext(colorSettings));
        DOMDocument xmlDocument = DOMParser.getInstance().parse(document, xmlLanguageService.getResolverExtensionManager());
        xmlLanguageService.setDocumentProvider(uri -> xmlDocument);
        ColorPresentationParams params = new ColorPresentationParams(new TextDocumentIdentifier(document.getUri()), color, range);
        List actual = xmlLanguageService.getColorPresentations(xmlDocument, params, () -> {});
        XMLAssert.assertColorPresentation(actual, expected);
    }

    public static void assertColorPresentation(List<? extends ColorPresentation> actual, ColorPresentation ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i].getLabel(), (Object)actual.get(i).getLabel());
            Assertions.assertEquals((Object)expected[i].getTextEdit(), (Object)actual.get(i).getTextEdit());
        }
    }

    public static ColorPresentation colorPres(String label, TextEdit textEdit) {
        return new ColorPresentation(label, textEdit);
    }

    public static class SettingsSaveContext
    extends AbstractSaveContext {
        public SettingsSaveContext(Object settings) {
            super(settings);
        }

        public DOMDocument getDocument(String uri) {
            return null;
        }

        public void collectDocumentToValidate(Predicate<DOMDocument> validateDocumentPredicate) {
        }
    }
}

