/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XSDRenameExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void testRenameComplexTypeName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n  <xs:element name=\"employee\" type=\"personinfo\"></xs:element>\r\n  <xs:complexType name=\"|personinfo\"></xs:complexType>\r\n  <xs:complexType name=\"fullpersoninfo\">\r\n    <xs:complexContent>\r\n      <xs:extension base=\"personinfo\"></xs:extension>\r\n    </xs:complexContent>\r\n  </xs:complexType>\r\n</xs:schema>";
        XMLAssert.assertRename(xml, "newName", XSDRenameExtensionsTest.edits("newName", XSDRenameExtensionsTest.r(4, 24, 34), XSDRenameExtensionsTest.r(3, 36, 46), XSDRenameExtensionsTest.r(7, 26, 36)));
    }

    @Test
    public void testRenameSimpleTypeName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xsd:schema elementFormDefault=\"qualified\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://invoice\" xmlns:i=\"http://invoice\">\r\n\t<xsd:simpleType name=\"paymentMe|thodType\">\r\n\t\t<xsd:restriction base=\"xsd:string\">\r\n\t\t</xsd:restriction>\r\n\t</xsd:simpleType>\r\n</xsd:schema>";
        XMLAssert.assertRename(xml, "newName", XSDRenameExtensionsTest.edits("newName", XSDRenameExtensionsTest.r(2, 23, 40)));
    }

    @Test
    public void testRenameSimpleTypeNameWithPrefix() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<xsd:schema elementFormDefault=\"qualified\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://invoice\" xmlns:i=\"http://invoice\">\r\n\t<xsd:complexType name=\"paymentType\">\r\n\t\t<xsd:attribute name=\"method\" type=\"i:paymentMethodType\" use=\"required\"></xsd:attribute>\r\n\t</xsd:complexType>\r\n\t<xsd:simpleType name=\"paymentMetho|dType\">\r\n\t\t<xsd:restriction base=\"xsd:string\">\r\n\t\t</xsd:restriction>\r\n\t</xsd:simpleType>\r\n</xsd:schema>";
        XMLAssert.assertRename(xml, "newName", XSDRenameExtensionsTest.edits("newName", XSDRenameExtensionsTest.r(5, 23, 40), XSDRenameExtensionsTest.r(3, 39, 56)));
    }

    private static Range r(int line, int startCharacter, int endCharacter) {
        return new Range(new Position(line, startCharacter), new Position(line, endCharacter));
    }

    private static List<TextEdit> edits(String newText, Range ... ranges) {
        return Stream.of(ranges).map(r -> new TextEdit(r, newText)).collect(Collectors.toList());
    }
}

