/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.diagnostics;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class RelaxNGCompactSyntaxDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void valid() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook.rnc\" ?>\r\n<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void invalidFileRnc() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBookXXX.rnc\" ?>\r\n<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 17, 64, (IXMLErrorCode)RelaxNGErrorCode.RelaxNGNotFound));
    }

    @Test
    public void unkwown_element() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/addressBook.rnc\" ?>\r\n<addressBook>\r\n  <card>\r\n    <nameXXX>John Smith</nameXXX>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(3, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.unknown_element), XMLAssert.d(4, 5, 10, (IXMLErrorCode)RelaxNGErrorCode.unexpected_element_required_element_missing));
    }

    @Test
    public void empty() throws Exception {
        String xml = "<?xml-model href=\"src/test/resources/relaxng/empty.rnc\" ?>\r\n<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(0, 17, 0, 55, null));
    }
}

