/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.Range;
import org.junit.jupiter.api.Test;

public class XMLModelHoverExtensionsTest
extends AbstractCacheBasedTest {
    private static final String HOVER_SEPARATOR = "___";

    @Test
    public void hoverBasedOnXSDWithXMLModel() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLModelHoverExtensionsTest.getXMLSchemaFileURI("spring-beans-3.0.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-model href=\"http://www.springframework.org/schema/beans/spring-beans.xsd\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" >\r\n\t<bea|n>";
        XMLModelHoverExtensionsTest.assertHover(xml, "Defines a single (usually named) bean. A bean definition may contain nested tags for constructor arguments, property values, lookup methods, and replaced methods. Mixing constructor injection and setter injection on the same bean is explicitly supported." + System.lineSeparator() + System.lineSeparator() + "Source: [spring-beans-3.0.xsd](" + schemaURI + ")", XMLAssert.r(3, 2, 3, 6));
    }

    @Test
    public void multipleXMLModel() throws BadLocationException, URI.MalformedURIException {
        String dtdURI = XMLModelHoverExtensionsTest.getXMLModelFileURI("grammar.dtd");
        String schemaURI = XMLModelHoverExtensionsTest.getXMLModelFileURI("grammar.xsd");
        String xml = "<?xml-model href=\"grammar.dtd\" ?>\r\n<?xml-model href=\"grammar.xsd\" ?>\r\n<grammar>\r\n\t<f|rom-xsd/></grammar>";
        XMLModelHoverExtensionsTest.assertHover(xml, "DTD documentation for from-xsd" + System.lineSeparator() + System.lineSeparator() + "Source: [grammar.dtd](" + dtdURI + ")" + System.lineSeparator() + System.lineSeparator() + HOVER_SEPARATOR + System.lineSeparator() + System.lineSeparator() + "XSD documentation for from-xsd" + System.lineSeparator() + System.lineSeparator() + "Source: [grammar.xsd](" + schemaURI + ")", XMLAssert.r(3, 2, 3, 10), "src/test/resources/xml-model/grammar.xml");
    }

    private static void assertHover(String value, String expectedHoverLabel, Range expectedHoverRange) throws BadLocationException {
        XMLModelHoverExtensionsTest.assertHover(value, expectedHoverLabel, expectedHoverRange, null);
    }

    private static void assertHover(String value, String expectedHoverLabel, Range expectedHoverRange, String fileURI) throws BadLocationException {
        XMLAssert.assertHover(new XMLLanguageService(), value, "src/test/resources/catalogs/catalog.xml", fileURI, expectedHoverLabel, expectedHoverRange);
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }

    private static String getXMLModelFileURI(String grammarURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)grammarURI, (String)"src/test/resources/xml-model/grammar.xml", (boolean)true).replace("///", "/");
    }
}

