/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons;

import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OutOfOrderRequestsTest {
    private static final TextDocumentIdentifier UNOPENED_DOC = new TextDocumentIdentifier("file:///file.xml");
    private TextDocumentService ls = null;

    @BeforeEach
    public void setupLS() {
        this.ls = new XMLTextDocumentService(new XMLLanguageServer());
    }

    @Test
    public void completion() {
        CompletionParams params = new CompletionParams(UNOPENED_DOC, new Position());
        ((CompletableFuture)this.ls.completion(params).thenAccept(completion -> Assertions.assertNull((Object)completion))).join();
    }

    @Test
    public void hover() {
        HoverParams params = new HoverParams(UNOPENED_DOC, new Position());
        ((CompletableFuture)this.ls.hover(params).thenAccept(hover -> Assertions.assertNull((Object)hover))).join();
    }

    @Test
    public void documentHighlight() {
        DocumentHighlightParams params = new DocumentHighlightParams(UNOPENED_DOC, new Position());
        ((CompletableFuture)this.ls.documentHighlight(params).thenAccept(documentHighlight -> Assertions.assertNull((Object)documentHighlight))).join();
    }

    @Test
    public void documentSymbol() {
        DocumentSymbolParams params = new DocumentSymbolParams(UNOPENED_DOC);
        ((CompletableFuture)this.ls.documentSymbol(params).thenAccept(documentSymbol -> Assertions.assertNull((Object)documentSymbol))).join();
    }

    @Test
    public void rename() {
        RenameParams params = new RenameParams(UNOPENED_DOC, new Position(), "");
        ((CompletableFuture)this.ls.rename(params).thenAccept(rename -> Assertions.assertNull((Object)rename))).join();
    }

    @Test
    public void foldingRange() {
        FoldingRangeRequestParams params = new FoldingRangeRequestParams(UNOPENED_DOC);
        ((CompletableFuture)this.ls.foldingRange(params).thenAccept(foldingRange -> Assertions.assertNull((Object)foldingRange))).join();
    }

    @Test
    public void documentLink() {
        DocumentLinkParams params = new DocumentLinkParams(UNOPENED_DOC);
        ((CompletableFuture)this.ls.documentLink(params).thenAccept(documentLink -> Assertions.assertNull((Object)documentLink))).join();
    }

    @Test
    public void definition() {
        DefinitionParams params = new DefinitionParams(UNOPENED_DOC, new Position());
        ((CompletableFuture)this.ls.definition(params).thenAccept(definition -> Assertions.assertNull((Object)definition))).join();
    }

    @Test
    public void typeDefinition() {
        TypeDefinitionParams params = new TypeDefinitionParams(UNOPENED_DOC, new Position());
        ((CompletableFuture)this.ls.typeDefinition(params).thenAccept(typeDefinition -> Assertions.assertNull((Object)typeDefinition))).join();
    }

    @Test
    public void references() {
        ReferenceParams params = new ReferenceParams(UNOPENED_DOC, new Position(), new ReferenceContext());
        ((CompletableFuture)this.ls.references(params).thenAccept(references -> Assertions.assertNull((Object)references))).join();
    }

    @Test
    public void codeLens() {
        CodeLensParams params = new CodeLensParams(UNOPENED_DOC);
        ((CompletableFuture)this.ls.codeLens(params).thenAccept(codeLens -> {
            Assertions.assertNotNull((Object)codeLens);
            Assertions.assertEquals((int)0, (int)codeLens.size(), (String)"Code lens is disabled, so it should return an empty list");
        })).join();
    }

    @Test
    public void formatting() {
        DocumentFormattingParams params = new DocumentFormattingParams(UNOPENED_DOC, new FormattingOptions());
        ((CompletableFuture)this.ls.formatting(params).thenAccept(formatting -> Assertions.assertNull((Object)formatting))).join();
    }

    @Test
    public void rangeFormatting() {
        DocumentRangeFormattingParams params = new DocumentRangeFormattingParams(UNOPENED_DOC, new FormattingOptions(), new Range());
        ((CompletableFuture)this.ls.rangeFormatting(params).thenAccept(formatting -> Assertions.assertNull((Object)formatting))).join();
    }
}

