/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.junit.jupiter.api.Test;

public class XMLLinkedEditingTest {
    @Test
    public void linkedEditingWithEmptyTag() throws BadLocationException {
        XMLAssert.testLinkedEditingFor("<|></>", XMLAssert.le(XMLAssert.r(0, 1, 0, 1), XMLAssert.r(0, 4, 0, 4)));
        XMLAssert.testLinkedEditingFor("<|>abcd</>", XMLAssert.le(XMLAssert.r(0, 1, 0, 1), XMLAssert.r(0, 8, 0, 8)));
    }

    @Test
    public void linkedEditingWithOrpheanEndTag() throws BadLocationException {
        XMLAssert.testLinkedEditingFor("<div></|", null);
        XMLAssert.testLinkedEditingFor("<di|v></", null);
        XMLAssert.testLinkedEditingFor("<|></", null);
    }

    @Test
    public void linkedEditing() throws BadLocationException {
        XMLAssert.testLinkedEditingFor("|<div></div>", null);
        XMLAssert.testLinkedEditingFor("<|div></div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<d|iv></div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<di|v></div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<div|></div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<div>|</div>", null);
        XMLAssert.testLinkedEditingFor("<div><|/div>", null);
        XMLAssert.testLinkedEditingFor("<div></|div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<div></d|iv>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<div></di|v>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<div></div|>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 7, 0, 10)));
        XMLAssert.testLinkedEditingFor("<div></div>|", null);
        XMLAssert.testLinkedEditingFor("<div><div|</div>", XMLAssert.le(XMLAssert.r(0, 6, 0, 9), XMLAssert.r(0, 11, 0, 14)));
        XMLAssert.testLinkedEditingFor("<div><div><div|</div></div>", XMLAssert.le(XMLAssert.r(0, 11, 0, 14), XMLAssert.r(0, 16, 0, 19)));
        XMLAssert.testLinkedEditingFor("<div| ></div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 8, 0, 11)));
        XMLAssert.testLinkedEditingFor("<div| id='foo'></div>", XMLAssert.le(XMLAssert.r(0, 1, 0, 4), XMLAssert.r(0, 16, 0, 19)));
    }
}

