/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMCDATAFormatter {
    private final XMLFormatterDocumentNew formatterDocument;

    public DOMCDATAFormatter(XMLFormatterDocumentNew formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatCDATASection(DOMCDATASection cDATANode, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        String text = this.formatterDocument.getText();
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        int spaceStart = -1;
        int spaceEnd = -1;
        for (int leftWhitespaceOffset = (start = cDATANode.getStart()) > 0 ? start - 1 : 0; leftWhitespaceOffset > 0 && Character.isWhitespace(text.charAt(leftWhitespaceOffset)); --leftWhitespaceOffset) {
        }
        if (this.isJoinCDATALines()) {
            int contentEnd = -1;
            int cDATAStartContent = cDATANode.getStartContent();
            int cDATAEndContent = cDATANode.getEndContent();
            for (int i = cDATAStartContent; i <= cDATAEndContent; ++i) {
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (spaceStart == -1) {
                        spaceStart = i;
                        continue;
                    }
                    spaceEnd = i;
                    continue;
                }
                int contentStart = i;
                while (i < cDATAEndContent && !Character.isWhitespace(text.charAt(i + 1))) {
                    ++i;
                }
                contentEnd = i;
                if ((availableLineWidth -= contentEnd + 1 - contentStart) <= 0) {
                    if (spaceStart == -1) continue;
                    this.replaceLeftSpacesWithIndentation(parentConstraints.getIndentLevel(), spaceStart, contentStart, true, edits);
                    int indentSpaces = this.getTabSize() * parentConstraints.getIndentLevel();
                    availableLineWidth = this.getMaxLineWidth() - indentSpaces - (contentEnd + 1 - contentStart);
                    continue;
                }
                if (spaceStart == cDATAStartContent) {
                    this.removeLeftSpaces(spaceStart, contentStart, edits);
                    spaceStart = -1;
                    spaceEnd = -1;
                    continue;
                }
                if (contentEnd == cDATAEndContent) {
                    this.removeLeftSpaces(spaceStart, contentEnd, edits);
                    spaceStart = -1;
                    spaceEnd = -1;
                    continue;
                }
                this.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
                --availableLineWidth;
                spaceStart = -1;
                spaceEnd = -1;
            }
        }
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private boolean isJoinCDATALines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isJoinCDATALines();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        this.formatterDocument.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }
}

